/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.api;

import java.util.Map;
import java.util.Objects;
import org.apache.dolphinscheduler.alert.api.AlertData;

public class AlertInfo {
    private Map<String, String> alertParams;
    private AlertData alertData;

    public AlertInfo(Map<String, String> alertParams, AlertData alertData) {
        this.alertParams = alertParams;
        this.alertData = alertData;
    }

    public AlertInfo() {
    }

    public static AlertInfoBuilder builder() {
        return new AlertInfoBuilder();
    }

    public Map<String, String> getAlertParams() {
        return this.alertParams;
    }

    public AlertInfo setAlertParams(Map<String, String> alertParams) {
        this.alertParams = alertParams;
        return this;
    }

    public AlertData getAlertData() {
        return this.alertData;
    }

    public AlertInfo setAlertData(AlertData alertData) {
        this.alertData = alertData;
        return this;
    }

    public boolean equals(Object o) {
        Map<String, String> otherAlertParams;
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertInfo)) {
            return false;
        }
        AlertInfo other = (AlertInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> thisAlertParams = this.getAlertParams();
        if (!Objects.equals(thisAlertParams, otherAlertParams = other.getAlertParams())) {
            return false;
        }
        AlertData thisAlertData = this.getAlertData();
        AlertData otherAlertData = other.getAlertData();
        return Objects.equals(thisAlertData, otherAlertData);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlertInfo;
    }

    public int hashCode() {
        int prime = 59;
        int result = 1;
        Map<String, String> alertParams = this.getAlertParams();
        result = result * 59 + (alertParams == null ? 43 : ((Object)alertParams).hashCode());
        AlertData alertData = this.getAlertData();
        result = result * 59 + (alertData == null ? 43 : ((Object)alertData).hashCode());
        return result;
    }

    public String toString() {
        return "AlertInfo(alertParams=" + this.getAlertParams() + ", alertData=" + this.getAlertData() + ")";
    }

    public static class AlertInfoBuilder {
        private Map<String, String> alertParams;
        private AlertData alertData;

        AlertInfoBuilder() {
        }

        public AlertInfoBuilder alertParams(Map<String, String> alertParams) {
            this.alertParams = alertParams;
            return this;
        }

        public AlertInfoBuilder alertData(AlertData alertData) {
            this.alertData = alertData;
            return this;
        }

        public AlertInfo build() {
            return new AlertInfo(this.alertParams, this.alertData);
        }

        public String toString() {
            return "AlertInfo.AlertInfoBuilder(alertParams=" + this.alertParams + ", alertData=" + this.alertData + ")";
        }
    }
}

