/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.api;

import java.util.Objects;

public class AlertResult {
    private String status;
    private String message;

    public AlertResult(String status, String message) {
        this.status = status;
        this.message = message;
    }

    public AlertResult() {
    }

    public static AlertResultBuilder builder() {
        return new AlertResultBuilder();
    }

    public String getStatus() {
        return this.status;
    }

    public AlertResult setStatus(String status) {
        this.status = status;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public AlertResult setMessage(String message) {
        this.message = message;
        return this;
    }

    public boolean equals(Object o) {
        String otherStatus;
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertResult)) {
            return false;
        }
        AlertResult other = (AlertResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String thisStatus = this.getStatus();
        if (!Objects.equals(thisStatus, otherStatus = other.getStatus())) {
            return false;
        }
        String thisMessage = this.getMessage();
        String otherMessage = other.getMessage();
        return Objects.equals(thisMessage, otherMessage);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlertResult;
    }

    public int hashCode() {
        int prime = 59;
        int result = 1;
        String s = this.getStatus();
        result = result * 59 + (s == null ? 43 : s.hashCode());
        String message = this.getMessage();
        result = result * 59 + (message == null ? 43 : message.hashCode());
        return result;
    }

    public String toString() {
        return "AlertResult(status=" + this.getStatus() + ", message=" + this.getMessage() + ")";
    }

    public static class AlertResultBuilder {
        private String status;
        private String message;

        AlertResultBuilder() {
        }

        public AlertResultBuilder status(String status) {
            this.status = status;
            return this;
        }

        public AlertResultBuilder message(String message) {
            this.message = message;
            return this;
        }

        public AlertResult build() {
            return new AlertResult(this.status, this.message);
        }

        public String toString() {
            return "AlertResult.AlertResultBuilder(status=" + this.status + ", message=" + this.message + ")";
        }
    }
}

