/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.http;

import com.google.auto.service.AutoService;
import java.util.Arrays;
import java.util.List;
import org.apache.dolphinscheduler.alert.api.AlertChannel;
import org.apache.dolphinscheduler.alert.api.AlertChannelFactory;
import org.apache.dolphinscheduler.plugin.alert.http.HttpAlertChannel;
import org.apache.dolphinscheduler.spi.params.base.PluginParams;
import org.apache.dolphinscheduler.spi.params.base.Validate;
import org.apache.dolphinscheduler.spi.params.input.InputParam;

@AutoService(value={AlertChannelFactory.class})
public final class HttpAlertChannelFactory
implements AlertChannelFactory {
    public String name() {
        return "Http";
    }

    public List<PluginParams> params() {
        InputParam url = InputParam.newBuilder((String)"url", (String)"$t('url')").setPlaceholder("input request URL").addValidate(Validate.newBuilder().setRequired(true).build()).build();
        InputParam headerParams = InputParam.newBuilder((String)"headerParams", (String)"$t('headerParams')").setPlaceholder("input request headers as JSON format ").addValidate(Validate.newBuilder().setRequired(true).build()).build();
        InputParam bodyParams = InputParam.newBuilder((String)"bodyParams", (String)"$t('bodyParams')").setPlaceholder("input request body as JSON format ").addValidate(Validate.newBuilder().setRequired(false).build()).build();
        InputParam contentField = InputParam.newBuilder((String)"contentField", (String)"$t('contentField')").setPlaceholder("input alert msg field name").addValidate(Validate.newBuilder().setRequired(true).build()).build();
        InputParam requestType = InputParam.newBuilder((String)"requestType", (String)"$t('requestType')").setPlaceholder("input request type POST or GET").addValidate(Validate.newBuilder().setRequired(true).build()).build();
        return Arrays.asList(url, requestType, headerParams, bodyParams, contentField);
    }

    public AlertChannel create() {
        return new HttpAlertChannel();
    }
}

