/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.script;

import com.google.auto.service.AutoService;
import java.util.Arrays;
import java.util.List;
import org.apache.dolphinscheduler.alert.api.AlertChannel;
import org.apache.dolphinscheduler.alert.api.AlertChannelFactory;
import org.apache.dolphinscheduler.plugin.alert.script.ScriptAlertChannel;
import org.apache.dolphinscheduler.plugin.alert.script.ScriptType;
import org.apache.dolphinscheduler.spi.params.base.ParamsOptions;
import org.apache.dolphinscheduler.spi.params.base.PluginParams;
import org.apache.dolphinscheduler.spi.params.base.Validate;
import org.apache.dolphinscheduler.spi.params.input.InputParam;
import org.apache.dolphinscheduler.spi.params.radio.RadioParam;

@AutoService(value={AlertChannelFactory.class})
public final class ScriptAlertChannelFactory
implements AlertChannelFactory {
    public String name() {
        return "Script";
    }

    public List<PluginParams> params() {
        InputParam scriptUserParam = InputParam.newBuilder((String)"userParams", (String)"$t('userParams')").addValidate(Validate.newBuilder().setRequired(false).build()).setPlaceholder("please enter your custom parameters, which will be passed to you when calling your script").build();
        InputParam scriptPathParam = InputParam.newBuilder((String)"path", (String)"$t('scriptPath')").addValidate(Validate.newBuilder().setRequired(true).build()).setPlaceholder("please upload the file to the disk directory of the alert server, and ensure that the path is absolute and has the corresponding access rights").build();
        RadioParam scriptTypeParams = RadioParam.newBuilder((String)"type", (String)"$t('scriptType')").addParamsOptions(new ParamsOptions(ScriptType.SHELL.getDescp(), (Object)ScriptType.SHELL.getDescp(), false)).setValue((Object)ScriptType.SHELL.getDescp()).addValidate(Validate.newBuilder().setRequired(true).build()).build();
        return Arrays.asList(scriptUserParam, scriptPathParam, scriptTypeParams);
    }

    public AlertChannel create() {
        return new ScriptAlertChannel();
    }
}

