/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.script;

import java.io.IOException;
import org.apache.dolphinscheduler.plugin.alert.script.StreamGobbler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProcessUtils.class);

    private ProcessUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static Integer executeScript(String ... cmd) {
        int exitCode = -1;
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        try {
            Process process = processBuilder.start();
            StreamGobbler inputStreamGobbler = new StreamGobbler(process.getInputStream());
            StreamGobbler errorStreamGobbler = new StreamGobbler(process.getErrorStream());
            inputStreamGobbler.start();
            errorStreamGobbler.start();
            return process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            logger.error("execute alert script error {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
            return exitCode;
        }
    }
}

