/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.log;

import io.netty.channel.Channel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.log.GetLogBytesRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.GetLogBytesResponseCommand;
import org.apache.dolphinscheduler.remote.command.log.RemoveTaskLogRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.RemoveTaskLogResponseCommand;
import org.apache.dolphinscheduler.remote.command.log.RollViewLogRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.RollViewLogResponseCommand;
import org.apache.dolphinscheduler.remote.command.log.ViewLogRequestCommand;
import org.apache.dolphinscheduler.remote.command.log.ViewLogResponseCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.remote.utils.Constants;
import org.apache.dolphinscheduler.remote.utils.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LoggerRequestProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(LoggerRequestProcessor.class);
    private final ExecutorService executor = Executors.newFixedThreadPool(Constants.CPUS * 2 + 1, (ThreadFactory)new NamedThreadFactory("Log-Request-Process-Thread"));

    public void process(Channel channel, Command command) {
        this.logger.info("received command : {}", (Object)command);
        CommandType commandType = command.getType();
        switch (commandType) {
            case GET_LOG_BYTES_REQUEST: {
                GetLogBytesRequestCommand getLogRequest = (GetLogBytesRequestCommand)JSONUtils.parseObject((byte[])command.getBody(), GetLogBytesRequestCommand.class);
                String path = getLogRequest.getPath();
                if (!this.checkPathSecurity(path)) {
                    throw new IllegalArgumentException("Illegal path: " + path);
                }
                byte[] bytes = this.getFileContentBytes(path);
                GetLogBytesResponseCommand getLogResponse = new GetLogBytesResponseCommand(bytes);
                channel.writeAndFlush((Object)getLogResponse.convert2Command(command.getOpaque()));
                break;
            }
            case VIEW_WHOLE_LOG_REQUEST: {
                ViewLogRequestCommand viewLogRequest = (ViewLogRequestCommand)JSONUtils.parseObject((byte[])command.getBody(), ViewLogRequestCommand.class);
                String viewLogPath = viewLogRequest.getPath();
                if (!this.checkPathSecurity(viewLogPath)) {
                    throw new IllegalArgumentException("Illegal path: " + viewLogPath);
                }
                String msg = LoggerUtils.readWholeFileContent((String)viewLogPath);
                ViewLogResponseCommand viewLogResponse = new ViewLogResponseCommand(msg);
                channel.writeAndFlush((Object)viewLogResponse.convert2Command(command.getOpaque()));
                break;
            }
            case ROLL_VIEW_LOG_REQUEST: {
                RollViewLogRequestCommand rollViewLogRequest = (RollViewLogRequestCommand)JSONUtils.parseObject((byte[])command.getBody(), RollViewLogRequestCommand.class);
                String rollViewLogPath = rollViewLogRequest.getPath();
                if (!this.checkPathSecurity(rollViewLogPath)) {
                    throw new IllegalArgumentException("Illegal path: " + rollViewLogPath);
                }
                List<String> lines = this.readPartFileContent(rollViewLogPath, rollViewLogRequest.getSkipLineNum(), rollViewLogRequest.getLimit());
                StringBuilder builder = new StringBuilder();
                int MaxResponseLogSize = 65535;
                int totalLogByteSize = 0;
                for (String line : lines) {
                    int lineByteSize = line.getBytes(StandardCharsets.UTF_8).length;
                    if (lineByteSize >= 65535) {
                        builder.append(line, 0, 65535).append(" [this line's size ").append(lineByteSize).append(" bytes is exceed ").append(65535).append(" bytes, so only ").append(65535).append(" characters are reserved for performance reasons.]").append("\r\n");
                    } else {
                        builder.append(line).append("\r\n");
                    }
                    if ((totalLogByteSize += lineByteSize) < 65535) continue;
                    break;
                }
                RollViewLogResponseCommand rollViewLogRequestResponse = new RollViewLogResponseCommand(builder.toString());
                channel.writeAndFlush((Object)rollViewLogRequestResponse.convert2Command(command.getOpaque()));
                break;
            }
            case REMOVE_TAK_LOG_REQUEST: {
                RemoveTaskLogRequestCommand removeTaskLogRequest = (RemoveTaskLogRequestCommand)JSONUtils.parseObject((byte[])command.getBody(), RemoveTaskLogRequestCommand.class);
                String taskLogPath = removeTaskLogRequest.getPath();
                if (!this.checkPathSecurity(taskLogPath)) {
                    throw new IllegalArgumentException("Illegal path: " + taskLogPath);
                }
                File taskLogFile = new File(taskLogPath);
                boolean status = true;
                try {
                    if (taskLogFile.exists()) {
                        status = taskLogFile.delete();
                    }
                }
                catch (Exception e) {
                    status = false;
                }
                RemoveTaskLogResponseCommand removeTaskLogResponse = new RemoveTaskLogResponseCommand(Boolean.valueOf(status));
                channel.writeAndFlush((Object)removeTaskLogResponse.convert2Command(command.getOpaque()));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown commandType: " + commandType);
            }
        }
    }

    private boolean checkPathSecurity(String path) {
        String dsHome = System.getProperty("DOLPHINSCHEDULER_WORKER_HOME");
        if (StringUtils.isBlank((CharSequence)dsHome)) {
            dsHome = System.getProperty("user.dir");
        }
        if (StringUtils.isBlank((CharSequence)path)) {
            this.logger.warn("path is null");
            return false;
        }
        return path.startsWith(dsHome) && !path.contains("../") && path.endsWith(".log");
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] getFileContentBytes(String filePath) {
        try (FileInputStream in = new FileInputStream(filePath);){
            byte[] byArray;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                int len;
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) != -1) {
                    bos.write(buf, 0, len);
                }
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            this.logger.error("get file bytes error", (Throwable)e);
            return new byte[0];
        }
    }

    private List<String> readPartFileContent(String filePath, int skipLine, int limit) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            List<String> list;
            block10: {
                Stream<String> stream = Files.lines(Paths.get(filePath, new String[0]));
                try {
                    list = stream.skip(skipLine).limit(limit).collect(Collectors.toList());
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.logger.error("read file error", (Throwable)e);
                    }
                }
                stream.close();
            }
            return list;
        } else {
            this.logger.info("file path: {} not exists", (Object)filePath);
        }
        return Collections.emptyList();
    }
}

