/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertyUtils.class);
    private static final Properties properties = new Properties();

    private PropertyUtils() {
        throw new IllegalStateException("PropertyUtils class");
    }

    public static String getString(String key, String defaultVal) {
        String val = properties.getProperty(key.trim());
        return val == null ? defaultVal : val;
    }

    public static String getString(String key) {
        if (key == null) {
            return null;
        }
        return properties.getProperty(key.trim());
    }

    public static int getInt(String key) {
        return PropertyUtils.getInt(key, -1);
    }

    public static int getInt(String key, int defaultValue) {
        String value = properties.getProperty(key.trim());
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.info(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static boolean getBoolean(String key) {
        String value = properties.getProperty(key.trim());
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public static Boolean getBoolean(String key, boolean defaultValue) {
        String value = properties.getProperty(key.trim());
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public static long getLong(String key, long defaultVal) {
        String val = PropertyUtils.getString(key);
        return val == null ? defaultVal : Long.parseLong(val);
    }

    public static long getLong(String key) {
        return PropertyUtils.getLong(key, -1L);
    }

    public static double getDouble(String key, double defaultVal) {
        String val = properties.getProperty(key.trim());
        return val == null ? defaultVal : Double.parseDouble(val);
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> type, T defaultValue) {
        String val = properties.getProperty(key.trim());
        return val == null ? defaultValue : Enum.valueOf(type, val);
    }

    static {
        String propertyFiles = "/plugin.properties";
        InputStream fis = null;
        try {
            fis = PropertyUtils.class.getResourceAsStream(propertyFiles);
            properties.load(fis);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            if (fis != null) {
                IOUtils.closeQuietly((InputStream)fis);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
    }
}

