/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import org.apache.dolphinscheduler.plugin.task.api.AbstractTaskExecutor;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;

public abstract class AbstractYarnTask
extends AbstractTaskExecutor {
    private ShellCommandExecutor shellCommandExecutor;

    public AbstractYarnTask(TaskExecutionContext taskRequest) {
        super(taskRequest);
        this.shellCommandExecutor = new ShellCommandExecutor(this::logHandle, taskRequest, this.logger);
    }

    @Override
    public void handle() throws Exception {
        try {
            TaskResponse response = this.shellCommandExecutor.run(this.buildCommand());
            this.setExitStatusCode(response.getExitStatusCode());
            this.setAppIds(response.getAppIds());
            this.setProcessId(response.getProcessId());
        }
        catch (Exception e) {
            this.logger.error("yarn process failure", (Throwable)e);
            this.exitStatusCode = -1;
            throw e;
        }
    }

    @Override
    public void cancelApplication(boolean status) throws Exception {
        this.cancel = true;
        this.shellCommandExecutor.cancelApplication();
    }

    protected abstract String buildCommand();

    protected abstract void setMainJarName();

    protected String getResourceNameOfMainJar(ResourceInfo mainJar) {
        if (null == mainJar) {
            throw new RuntimeException("The jar for the task is required.");
        }
        return mainJar.getId() == 0 ? mainJar.getRes() : mainJar.getResourceName().replaceFirst("/", "");
    }
}

