/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;

public class TaskExecutionContextCacheManager {
    private static Map<Integer, TaskExecutionContext> taskRequestContextCache = new ConcurrentHashMap<Integer, TaskExecutionContext>();

    private TaskExecutionContextCacheManager() {
        throw new IllegalStateException("Utility class");
    }

    public static TaskExecutionContext getByTaskInstanceId(Integer taskInstanceId) {
        return taskRequestContextCache.get(taskInstanceId);
    }

    public static void cacheTaskExecutionContext(TaskExecutionContext request) {
        taskRequestContextCache.put(request.getTaskInstanceId(), request);
    }

    public static void removeByTaskInstanceId(Integer taskInstanceId) {
        taskRequestContextCache.remove(taskInstanceId);
    }

    public static boolean updateTaskExecutionContext(TaskExecutionContext request) {
        taskRequestContextCache.computeIfPresent(request.getTaskInstanceId(), (k, v) -> request);
        return taskRequestContextCache.containsKey(request.getTaskInstanceId());
    }

    public static Collection<TaskExecutionContext> getAllTaskRequestList() {
        return taskRequestContextCache.values();
    }
}

