/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.HashMap;

public enum ExecutionStatus {
    SUBMITTED_SUCCESS(0, "submit success"),
    RUNNING_EXECUTION(1, "running"),
    READY_PAUSE(2, "ready pause"),
    PAUSE(3, "pause"),
    READY_STOP(4, "ready stop"),
    STOP(5, "stop"),
    FAILURE(6, "failure"),
    SUCCESS(7, "success"),
    NEED_FAULT_TOLERANCE(8, "need fault tolerance"),
    KILL(9, "kill"),
    WAITING_THREAD(10, "waiting thread"),
    WAITING_DEPEND(11, "waiting depend node complete"),
    DELAY_EXECUTION(12, "delay execution"),
    FORCED_SUCCESS(13, "forced success"),
    SERIAL_WAIT(14, "serial wait"),
    READY_BLOCK(15, "ready block"),
    BLOCK(16, "block"),
    DISPATCH(17, "dispatch");

    @EnumValue
    private final int code;
    private final String descp;
    private static HashMap<Integer, ExecutionStatus> EXECUTION_STATUS_MAP;
    private static final int[] NEED_FAILOVER_STATES;

    private ExecutionStatus(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public boolean typeIsSuccess() {
        return this == SUCCESS || this == FORCED_SUCCESS;
    }

    public boolean typeIsFailure() {
        return this == FAILURE || this == NEED_FAULT_TOLERANCE;
    }

    public boolean typeIsFinished() {
        return this.typeIsSuccess() || this.typeIsFailure() || this.typeIsCancel() || this.typeIsPause() || this.typeIsStop() || this.typeIsBlock();
    }

    public boolean typeIsWaitingThread() {
        return this == WAITING_THREAD;
    }

    public boolean typeIsPause() {
        return this == PAUSE;
    }

    public boolean typeIsStop() {
        return this == STOP;
    }

    public boolean typeIsRunning() {
        return this == RUNNING_EXECUTION || this == WAITING_DEPEND || this == DELAY_EXECUTION;
    }

    public boolean typeIsBlock() {
        return this == BLOCK;
    }

    public boolean typeIsCancel() {
        return this == KILL || this == STOP;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }

    public static ExecutionStatus of(int status) {
        if (EXECUTION_STATUS_MAP.containsKey(status)) {
            return EXECUTION_STATUS_MAP.get(status);
        }
        throw new IllegalArgumentException("invalid status : " + status);
    }

    public static boolean isNeedFailoverWorkflowInstanceState(ExecutionStatus executionStatus) {
        return SUBMITTED_SUCCESS == executionStatus || DISPATCH == executionStatus || RUNNING_EXECUTION == executionStatus || DELAY_EXECUTION == executionStatus || READY_PAUSE == executionStatus || READY_STOP == executionStatus;
    }

    public static int[] getNeedFailoverWorkflowInstanceState() {
        return NEED_FAILOVER_STATES;
    }

    static {
        EXECUTION_STATUS_MAP = new HashMap();
        NEED_FAILOVER_STATES = new int[]{SUBMITTED_SUCCESS.ordinal(), DISPATCH.ordinal(), RUNNING_EXECUTION.ordinal(), DELAY_EXECUTION.ordinal(), READY_PAUSE.ordinal(), READY_STOP.ordinal()};
        for (ExecutionStatus executionStatus : ExecutionStatus.values()) {
            EXECUTION_STATUS_MAP.put(executionStatus.code, executionStatus);
        }
    }
}

