/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.zeppelin;

import org.apache.dolphinscheduler.plugin.task.api.AbstractTaskExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.zeppelin.ZeppelinParameters;
import org.apache.dolphinscheduler.plugin.task.zeppelin.ZeppelinTaskException;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.utils.PropertyUtils;
import org.apache.zeppelin.client.ClientConfig;
import org.apache.zeppelin.client.ParagraphResult;
import org.apache.zeppelin.client.Status;
import org.apache.zeppelin.client.ZeppelinClient;

public class ZeppelinTask
extends AbstractTaskExecutor {
    private final TaskExecutionContext taskExecutionContext;
    private ZeppelinParameters zeppelinParameters;
    private ZeppelinClient zClient;

    protected ZeppelinTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        String taskParams = this.taskExecutionContext.getTaskParams();
        this.logger.info("zeppelin task params:{}", (Object)taskParams);
        this.zeppelinParameters = (ZeppelinParameters)((Object)JSONUtils.parseObject((String)taskParams, ZeppelinParameters.class));
        if (this.zeppelinParameters == null || !this.zeppelinParameters.checkParameters()) {
            throw new ZeppelinTaskException("zeppelin task params is not valid");
        }
        this.zClient = this.getZeppelinClient();
    }

    public void handle() throws Exception {
        try {
            String noteId = this.zeppelinParameters.getNoteId();
            String paragraphId = this.zeppelinParameters.getParagraphId();
            ParagraphResult paragraphResult = this.zClient.executeParagraph(noteId, paragraphId);
            String resultContent = paragraphResult.getResultInText();
            Status status = paragraphResult.getStatus();
            int exitStatusCode = this.mapStatusToExitCode(status);
            this.setAppIds(String.format("%s-%s", noteId, paragraphId));
            this.setExitStatusCode(exitStatusCode);
            this.logger.info("zeppelin task finished with results: {}", (Object)resultContent);
        }
        catch (Exception e) {
            this.setExitStatusCode(-1);
            this.logger.error("zeppelin task submit failed with error", (Throwable)e);
        }
    }

    private ZeppelinClient getZeppelinClient() {
        String zeppelinRestUrl = PropertyUtils.getString((String)"zeppelin.rest.url");
        ClientConfig clientConfig = new ClientConfig(zeppelinRestUrl);
        ZeppelinClient zClient = null;
        try {
            zClient = new ZeppelinClient(clientConfig);
            String zeppelinVersion = zClient.getVersion();
            this.logger.info("zeppelin version: {}", (Object)zeppelinVersion);
        }
        catch (Exception e) {
            this.logger.error("some error");
        }
        return zClient;
    }

    private int mapStatusToExitCode(Status status) {
        switch (status) {
            case FINISHED: {
                return 0;
            }
            case ABORT: {
                return 137;
            }
        }
        return -1;
    }

    public AbstractParameters getParameters() {
        return this.zeppelinParameters;
    }

    public void cancelApplication(boolean status) throws Exception {
        super.cancelApplication(status);
        String noteId = this.zeppelinParameters.getNoteId();
        String paragraphId = this.zeppelinParameters.getParagraphId();
        this.logger.info("trying terminate zeppelin task, taskId: {}, noteId: {}, paragraphId: {}", new Object[]{this.taskExecutionContext.getTaskInstanceId(), noteId, paragraphId});
        this.zClient.cancelParagraph(noteId, paragraphId);
        this.logger.info("zeppelin task terminated, taskId: {}, noteId: {}, paragraphId: {}", new Object[]{this.taskExecutionContext.getTaskInstanceId(), noteId, paragraphId});
    }
}

