/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.codegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.empire.db.codegen.CodeGenerator;
import org.apache.empire.db.codegen.util.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CodeGenAppTest {
    @Before
    public void cleanup() throws IOException {
        boolean deleted;
        File generated = new File("target/generated");
        if (generated.exists() && !(deleted = FileUtils.deleteDirectory((File)generated))) {
            throw new IOException("Could not delete previously generated sources");
        }
    }

    @Test
    public void testMain() {
        String[] args = new String[]{"src/test/resources/testconfig.xml"};
        CodeGenerator.main((String[])args);
        File expected = new File("target/generated/dbsample/org/apache/empire/db/samples/dbsample/SampleDB.java");
        Assert.assertTrue((String)"missing generated code", (boolean)expected.exists());
    }

    @Test
    public void testMainDefaultTemplateFolderNested() {
        String[] args = new String[]{"src/test/resources/testconfig_default_template_folder_nested.xml"};
        CodeGenerator.main((String[])args);
        File expectedFile = new File("target/generated/dbsample/org/apache/empire/db/samples/dbsample/SampleDB.java");
        String expectedContent = "addColumn(";
        String fileContent = "";
        try {
            FileInputStream fis = new FileInputStream(expectedFile);
            byte[] buff = new byte[fis.available()];
            fis.read(buff);
            fileContent = new String(buff);
            fis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((String)"missing generated code for nested table classes", (boolean)fileContent.contains(expectedContent));
    }

    @Test
    public void testMainUsingTemplateFolder() {
        String[] args = new String[]{"src/test/resources/testconfig_using_template_folder.xml"};
        CodeGenerator.main((String[])args);
        File expected = new File("target/generated/dbsample/org/apache/empire/db/samples/dbsample/SampleDB.java");
        Assert.assertTrue((String)"missing generated code", (boolean)expected.exists());
    }

    @Test
    public void testMainFailInvalidTemplateFolder() {
        String[] args = new String[]{"src/test/resources/testconfig_invalid_template_folder.xml"};
        try {
            CodeGenerator.main((String[])args);
            Assert.fail((String)"This should fail as the template path is missing");
        }
        catch (RuntimeException ex) {
            Assert.assertTrue((String)"Wrong message", (boolean)ex.getMessage().startsWith("Provided template folder missing or not readable:"));
        }
    }
}

