/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.codegen;

import java.util.List;
import org.apache.empire.data.DataType;
import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBRelation;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.codegen.CodeGenConfig;
import org.apache.empire.db.codegen.CodeGenParser;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CodeGenParserTest {
    private transient CodeGenParser parser;

    @Before
    public void setUp() throws Exception {
        CodeGenConfig config = new CodeGenConfig();
        config.init("src/test/resources/testconfig.xml");
        config.setDbSchema("PUBLIC");
        config.setDbTablePattern("DEPARTMENTS,EMPLOYEES,ORGANIZATIONS");
        this.parser = new CodeGenParser(config);
    }

    @Test
    public void testLoadDbModel() {
        DBDatabase db = this.parser.loadDbModel();
        DBTable departments = db.getTable("DEPARTMENTS");
        DBTable employees = db.getTable("EMPLOYEES");
        Assert.assertNotNull((String)"Expected DEPARTMENTS table.", (Object)departments);
        Assert.assertNotNull((String)"Expected EMPLOYEES table.", (Object)employees);
        List relations = db.getRelations();
        Assert.assertEquals((String)"Should have one relation.", (long)1L, (long)relations.size());
        DBRelation dbRelation = (DBRelation)relations.get(0);
        Assert.assertEquals((Object)"EMPLOYEES_DEPARTMENT_I_FK", (Object)dbRelation.getName());
        DBRelation.DBReference[] references = dbRelation.getReferences();
        Assert.assertEquals((String)"Should reference one column.", (long)1L, (long)references.length);
        DBRelation.DBReference dbReference = references[0];
        Assert.assertEquals((Object)dbReference.getSourceColumn(), (Object)employees.getColumn("DEPARTMENT_ID"));
        Assert.assertEquals((Object)dbReference.getTargetColumn(), (Object)departments.getColumn("DEPARTMENT_ID"));
        DBColumn salary = employees.getColumn("SALARY");
        Assert.assertThat((Object)salary.getDataType(), (Matcher)Is.is((Object)DataType.DECIMAL));
        Assert.assertThat((Object)salary.getSize(), (Matcher)Is.is((Object)10.2));
    }
}

