/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.action;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.util.ValueStack;
import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.empire.commons.ErrorType;
import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.struts2.action.ActionAccessValidator;
import org.apache.empire.struts2.action.ActionErrorProvider;
import org.apache.empire.struts2.action.Disposable;
import org.apache.empire.struts2.action.ErrorInfo;
import org.apache.empire.struts2.action.ExceptionAware;
import org.apache.empire.struts2.actionsupport.ActionBase;
import org.apache.empire.struts2.actionsupport.ActionError;
import org.apache.empire.struts2.actionsupport.ActionPropertySupport;
import org.apache.empire.struts2.actionsupport.TextProviderActionSupport;
import org.apache.empire.struts2.web.EmpireThreadManager;
import org.apache.empire.struts2.web.FieldErrors;
import org.apache.empire.struts2.web.UrlHelperEx;
import org.apache.empire.struts2.web.WebRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebAction
extends ActionBase
implements Disposable,
ExceptionAware,
ActionAccessValidator,
ActionErrorProvider,
TextProvider {
    protected static Logger log = LoggerFactory.getLogger(WebAction.class);
    public static String DEFAULT_ITEM_PROPERTY_NAME = "item";
    public static String PORTLET_ACTION_RESULT = "struts.portlet.actionResult";
    private final transient TextProvider textProvider = TextProviderActionSupport.getInstance(this.getClass(), this);
    private ActionPropertySupport itemProperty = new ActionPropertySupport(this, DEFAULT_ITEM_PROPERTY_NAME, true);
    private final String LAST_ACTION_ERROR_ATTRIBUTE = "lastActionError";
    private ActionError actionError;
    private Map<String, ErrorInfo> fieldErrors;
    private final String LAST_ACTION_MESSAGE_ATTRIBUTE = "lastActionMessage";

    @Override
    public void init() {
    }

    @Override
    public int dispose() {
        if (this.hasActionError()) {
            return -1;
        }
        return 0;
    }

    @Override
    public String handleException(Throwable exception, String method) {
        ActionError excetionError = new ActionError(exception);
        if (this.actionError != null && this.actionError.hasError()) {
            log.warn("An uncaught exception occurred after an error has already been set!");
            log.warn("Replacing error of " + this.actionError.getErrorMessage() + " with " + excetionError.getErrorMessage());
        } else {
            log.warn("An uncaught exception occurred. Message is " + excetionError.getErrorMessage());
        }
        this.setActionError(excetionError);
        return null;
    }

    @Override
    public boolean loginRequired() {
        return false;
    }

    @Override
    public boolean hasAccess(String method) {
        return true;
    }

    @Override
    public boolean hasActionError() {
        return this.actionError != null && this.actionError.hasError() || this.fieldErrors != null;
    }

    @Override
    public void clearActionErrors() {
        this.actionError = null;
        this.fieldErrors = null;
        ActionContext context = ActionContext.getContext();
        if (context != null) {
            context.getSession().remove("lastActionError");
        }
    }

    @Override
    public ErrorInfo getLastActionError(boolean clear) {
        ActionContext context = ActionContext.getContext();
        ErrorInfo error = (ErrorInfo)context.getSession().get("lastActionError");
        if (clear) {
            context.getSession().remove("lastActionError");
        }
        return error;
    }

    @Override
    public String getLocalizedErrorMessage(ErrorInfo error) {
        if (error == null) {
            return "";
        }
        String msgKey = error.getErrorType().getKey();
        String[] args = ObjectUtils.toStringArray((Object[])error.getErrorParams(), (String)"Null");
        return this.getText(msgKey, args);
    }

    protected void setActionError(ErrorInfo error) {
        if (error == null) {
            this.actionError = null;
            return;
        }
        this.actionError = error instanceof ActionError ? (ActionError)error : new ActionError(error);
        ActionContext context = ActionContext.getContext();
        context.getSession().put("lastActionError", this.actionError);
    }

    protected final void setActionError(ErrorType errType) {
        this.setActionError(new ActionError(errType));
    }

    protected final void setActionError(ErrorType errType, String param) {
        this.setActionError(new ActionError(errType, param));
    }

    @Override
    public final void setActionError(Exception exception) {
        this.setActionError(new ActionError(exception));
    }

    @Override
    public Map<String, ErrorInfo> getItemErrors() {
        return this.fieldErrors;
    }

    private void addItemError(String item, ActionError error) {
        if (this.fieldErrors == null) {
            this.fieldErrors = new LinkedHashMap<String, ErrorInfo>();
        }
        if (log.isWarnEnabled()) {
            log.warn("Invlalid value for item or field " + item + " Message= " + error.getErrorMessage());
        }
        this.fieldErrors.put(item, error);
    }

    protected void addItemError(String item, ErrorType errorType, String title, ErrorInfo error) {
        if (error == null) {
            log.error("addItemError has been called without an error provided!");
            return;
        }
        if (title.startsWith("!")) {
            title = this.getText(title.substring(1));
        }
        String msgKey = error.getErrorType().getKey();
        String[] args = ObjectUtils.toStringArray((Object[])error.getErrorParams(), (String)"Null");
        String msg = this.getText(msgKey, args);
        this.addItemError(item, new ActionError(errorType, new String[]{title, msg}));
    }

    @Override
    protected void addFieldError(String name, Column column, ErrorInfo error) {
        this.addItemError(name, FieldErrors.FieldError, column.getTitle(), error);
    }

    @Override
    public String getLastActionMessage(boolean clear) {
        ActionContext context = ActionContext.getContext();
        Object msg = context.getSession().get("lastActionMessage");
        if (clear) {
            context.getSession().remove("lastActionMessage");
        }
        return StringUtils.toString(msg);
    }

    protected void setActionMessage(String message) {
        if (message.startsWith("!")) {
            message = this.getText(message.substring(1));
        }
        ActionContext context = ActionContext.getContext();
        context.getSession().put("lastActionMessage", message);
    }

    public Locale getLocale() {
        return ActionContext.getContext().getLocale();
    }

    public boolean hasKey(String key) {
        return this.textProvider.hasKey(key);
    }

    public String getText(String aTextName) {
        return this.textProvider.getText(aTextName);
    }

    public String getText(String aTextName, String defaultValue) {
        return this.textProvider.getText(aTextName, defaultValue);
    }

    public String getText(String aTextName, String defaultValue, String obj) {
        return this.textProvider.getText(aTextName, defaultValue, obj);
    }

    public String getText(String aTextName, List<Object> args) {
        return this.textProvider.getText(aTextName, args);
    }

    public String getText(String key, String[] args) {
        return this.textProvider.getText(key, args);
    }

    public String getText(String aTextName, String defaultValue, List<Object> args) {
        return this.textProvider.getText(aTextName, defaultValue, args);
    }

    public String getText(String key, String defaultValue, String[] args) {
        return this.textProvider.getText(key, defaultValue, args);
    }

    public String getText(String key, String defaultValue, List<Object> args, ValueStack stack) {
        return this.textProvider.getText(key, defaultValue, args, stack);
    }

    public String getText(String key, String defaultValue, String[] args, ValueStack stack) {
        return this.textProvider.getText(key, defaultValue, args, stack);
    }

    public ResourceBundle getTexts() {
        return this.textProvider.getTexts();
    }

    public ResourceBundle getTexts(String aBundleName) {
        return this.textProvider.getTexts(aBundleName);
    }

    @Override
    public int getListPageSize() {
        return -1;
    }

    @Override
    protected Connection getConnection() {
        return null;
    }

    @Override
    public String getItemPropertyName() {
        return this.itemProperty.getName();
    }

    public String getItem() {
        return this.itemProperty.getValue();
    }

    public void setItem(String value) {
        this.itemProperty.setValue(value);
    }

    public void clearItem() {
        this.itemProperty.clear();
    }

    public boolean isNewItem() {
        return this.getItemNewFlag();
    }

    protected final boolean hasItem(boolean lookOnSession) {
        return this.itemProperty.hasValue(lookOnSession);
    }

    protected final Object[] getItemKey() {
        return this.getRecordKeyFromString(this.getItem());
    }

    protected final boolean getItemNewFlag() {
        return this.getRecordNewFlagFromString(this.getItem());
    }

    @Override
    public final Map<String, Object> getRequestParameters() {
        ActionContext context = ActionContext.getContext();
        return context != null ? context.getParameters() : null;
    }

    @Override
    public final boolean hasRequestParam(String param) {
        return this.getRequestParam(param) != null;
    }

    @Override
    public final String getRequestParam(String param) {
        Map<String, Object> params = this.getRequestParameters();
        Object value = params.get(param);
        if (value == null) {
            return null;
        }
        if (value instanceof String[]) {
            return ((String[])value)[0];
        }
        return value.toString();
    }

    @Override
    public final String[] getRequestArrayParam(String param) {
        Map<String, Object> params = this.getRequestParameters();
        Object value = params.get(param);
        if (value == null) {
            return null;
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        return new String[]{value.toString()};
    }

    public final Integer getRequestIntParam(String param) {
        String s = this.getRequestParam(param);
        if (s == null) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public final void putRequestParam(String name, String value) {
        Map<String, Object> params = this.getRequestParameters();
        if (value != null) {
            params.put(name, new String[]{value});
        } else {
            params.remove(name);
        }
    }

    protected String getActionParam(String name) {
        if (name == null || name.length() == 0) {
            log.error("Invalid value for parameter 'name'");
            return null;
        }
        String item = this.getRequestParam(name);
        if (item == null) {
            return StringUtils.toString((Object)this.getActionObject(name));
        }
        this.putActionObject(name, item);
        return item;
    }

    @Deprecated
    public String getActionURL(String action, Map<String, Object> parameters) {
        Object request = EmpireThreadManager.getCurrentRequest();
        if (!(request instanceof WebRequest)) {
            log.error("cannot determine action URL. Request object does not implement WebRequest");
            return null;
        }
        WebRequest webRequest = (WebRequest)request;
        String uri = "/" + action;
        if (uri.indexOf(46) < 0) {
            uri = uri + ".action";
        }
        return UrlHelperEx.buildUrl(uri, webRequest.getRequestContext(), webRequest.getResponseContext(), parameters, null, true, true);
    }

    public String renderPortlet() {
        Map sessionMap = ActionContext.getContext().getSession();
        Object result = sessionMap.get(PORTLET_ACTION_RESULT);
        if (log.isDebugEnabled()) {
            log.debug("Processing portlet render result with result=" + result);
        }
        return result.toString();
    }
}

