/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.actionsupport;

import org.apache.empire.commons.StringUtils;
import org.apache.empire.struts2.actionsupport.ActionBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionPropertySupport {
    protected static Logger log = LoggerFactory.getLogger(ActionPropertySupport.class);
    private ActionBase action;
    private String propertyName;
    private boolean persist;
    private String value;

    public ActionPropertySupport(ActionBase action, String propertyName, boolean persist) {
        this.action = action;
        this.propertyName = propertyName;
        this.persist = persist;
    }

    public String getName() {
        return this.propertyName;
    }

    public String getValue() {
        if (this.value == null) {
            this.value = this.action.getRequestParam(this.propertyName);
            if (this.value != null) {
                this.setValue(this.value);
            }
        }
        if (this.value == null && this.persist) {
            return StringUtils.toString((Object)this.action.getActionObject(this.propertyName));
        }
        return this.value;
    }

    public void setValue(String value) {
        if (value == null) {
            log.error("Cannot set action item to null. Use clearitem() to remove the item from the session");
            return;
        }
        if (this.persist) {
            this.action.putActionObject(this.propertyName, value);
        }
        this.value = value;
    }

    public boolean setFromRequest() {
        String param = this.action.getRequestParam(this.propertyName);
        if (param == null) {
            return false;
        }
        this.setValue(param);
        return true;
    }

    public void clear() {
        if (this.persist) {
            this.action.removeActionObject(this.propertyName);
        }
        this.value = null;
    }

    public boolean hasValue(boolean lookOnSession) {
        if (!lookOnSession) {
            return this.action.getRequestParam(this.propertyName) != null;
        }
        return this.getValue() != null;
    }
}

