/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.actionsupport;

import java.util.List;
import org.apache.empire.data.Column;
import org.apache.empire.data.Record;
import org.apache.empire.data.bean.BeanClass;
import org.apache.empire.data.bean.BeanRecordProxy;
import org.apache.empire.exceptions.ObjectNotValidException;
import org.apache.empire.struts2.actionsupport.ActionBase;
import org.apache.empire.struts2.actionsupport.RecordFormActionSupport;
import org.apache.empire.struts2.actionsupport.SessionPersistence;
import org.apache.empire.struts2.exceptions.InvalidFormDataException;

public class BeanActionSupport<T>
extends RecordFormActionSupport {
    private BeanRecordProxy<T> record;

    public BeanActionSupport(ActionBase action, BeanRecordProxy<T> record, SessionPersistence persistence, String propertyName) {
        super(action, persistence, propertyName);
        this.record = record;
    }

    public BeanActionSupport(ActionBase action, BeanRecordProxy<T> record, SessionPersistence persistence) {
        this(action, record, persistence, action.getItemPropertyName());
    }

    public BeanActionSupport(ActionBase action, BeanClass beanClass, SessionPersistence persistence, String propertyName) {
        this(action, new BeanRecordProxy(beanClass), persistence, propertyName);
    }

    public BeanActionSupport(ActionBase action, BeanClass beanClass, SessionPersistence persistence) {
        this(action, new BeanRecordProxy(beanClass), persistence, action.getItemPropertyName());
    }

    public BeanActionSupport(ActionBase action, List<Column> updateColumns, Column[] keyColumns, SessionPersistence persistence, String propertyName) {
        this(action, new BeanRecordProxy(updateColumns, keyColumns), persistence, propertyName);
    }

    public BeanActionSupport(ActionBase action, List<Column> updateColumns, Column[] keyColumns, SessionPersistence persistence) {
        this(action, updateColumns, keyColumns, persistence, action.getItemPropertyName());
    }

    public BeanActionSupport(ActionBase action, List<Column> updateColumns, Column keyColumn, SessionPersistence persistence) {
        this(action, updateColumns, new Column[]{keyColumn}, persistence, action.getItemPropertyName());
    }

    @Override
    public Record getRecord() {
        if (!this.record.isValid() && this.getPersistence() == SessionPersistence.Data) {
            this.record = (BeanRecordProxy)this.getRecordFromSession();
        }
        return this.record;
    }

    public boolean isValid() {
        return this.getRecord().isValid();
    }

    public T getData() {
        this.getRecord();
        return (T)this.record.getBean();
    }

    public void setData(T data) {
        this.record.setBean(data);
        if (this.record.isValid()) {
            this.persistOnSession();
        } else {
            this.removeFromSession();
        }
    }

    public Object[] getRecordKeyValues() {
        if (!this.isValid()) {
            return null;
        }
        return this.record.getKeyValues();
    }

    public boolean checkKey() {
        if (!this.isValid()) {
            return false;
        }
        Object[] updKey = this.getActionParamKey();
        Object[] curKey = this.getRecordKeyValues();
        return this.compareKey(curKey, updKey);
    }

    public void updateSessionKey() {
        if (this.record.isValid()) {
            this.persistOnSession();
        } else {
            this.removeFromSession();
        }
    }

    public void initKeyColumns() {
        Object[] keyValues = this.getActionParamKey();
        if (!this.isValid() || keyValues == null) {
            throw new InvalidFormDataException();
        }
        if (this.record == null || !this.record.isValid()) {
            throw new ObjectNotValidException(this.record);
        }
        Column[] keyColumns = this.record.getKeyColumns();
        if (keyValues.length != keyColumns.length) {
            throw new InvalidFormDataException();
        }
        for (int i = 0; i < keyColumns.length; ++i) {
            this.record.setValue(keyColumns[i], keyValues[i]);
        }
    }
}

