/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.actionsupport;

import org.apache.empire.data.ColumnExpr;
import org.apache.empire.struts2.action.ListPagingInfo;
import org.apache.empire.struts2.action.ListSortingInfo;
import org.apache.empire.struts2.actionsupport.ActionBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ListActionSupport
implements ListPagingInfo,
ListSortingInfo {
    protected static Logger log = LoggerFactory.getLogger(ListActionSupport.class);
    protected ActionBase action;
    protected String propertyName;
    private ListPageInfo lpi = null;
    private ListSortInfo listSortInfo = null;

    public ListActionSupport(ActionBase action, String propertyName) {
        this.action = action;
        this.propertyName = propertyName;
    }

    @Override
    public String getListPropertyName() {
        return this.propertyName;
    }

    protected ListPageInfo getListPageInfo() {
        if (this.lpi == null) {
            this.lpi = (ListPageInfo)this.action.getActionBean(ListPageInfo.class, true, this.propertyName);
        }
        return this.lpi;
    }

    @Override
    public int getPageSize() {
        return this.action.getListPageSize();
    }

    protected void setFirstItem(int firstItemIndex) {
        this.getListPageInfo().firstItemIndex = firstItemIndex;
    }

    @Override
    public int getFirstItemIndex() {
        return this.getListPageInfo().firstItemIndex;
    }

    @Override
    public int getLastItemIndex() {
        int first = this.getFirstItemIndex();
        return Math.min(first + this.getPageSize() - 1, this.getItemCount() - 1);
    }

    @Override
    public int getItemCount() {
        return this.getListPageInfo().itemCount;
    }

    public void setItemCount(int itemCount) {
        this.getListPageInfo().firstItemIndex = 0;
        this.getListPageInfo().itemCount = itemCount;
    }

    @Override
    public int getPageCount() {
        if (this.getItemCount() % this.getPageSize() == 0) {
            return this.getItemCount() / this.getPageSize();
        }
        return this.getItemCount() / this.getPageSize() + 1;
    }

    @Override
    public int getPage() {
        return this.getFirstItemIndex() / this.getPageSize();
    }

    @Override
    public void setPage(int page) {
        if (page > this.getPageCount()) {
            page = this.getPageCount();
        }
        this.setFirstItem(page * this.getPageSize());
    }

    protected ListSortInfo getListSortInfo() {
        if (this.listSortInfo == null) {
            this.listSortInfo = (ListSortInfo)this.action.getActionBean(ListSortInfo.class, true, this.propertyName);
        }
        return this.listSortInfo;
    }

    @Override
    public String getSortColumn() {
        return this.getListSortInfo().sortColumn;
    }

    public void setSortColumn(ColumnExpr column) {
        this.getListSortInfo().sortColumn = column.getName();
    }

    @Override
    public void setSortColumn(String column) {
        ListSortInfo lsi = this.getListSortInfo();
        if (column != null && column.equalsIgnoreCase(lsi.sortColumn)) {
            lsi.sortDescending = !lsi.sortDescending;
        } else {
            lsi.sortColumn = column;
            lsi.sortDescending = false;
        }
    }

    @Override
    public boolean isSortDescending() {
        return this.getListSortInfo().sortDescending;
    }

    @Override
    public void setSortDescending(boolean sortDescending) {
        this.getListSortInfo().sortDescending = sortDescending;
    }

    protected static final class ListSortInfo {
        public String sortColumn;
        public boolean sortDescending;

        protected ListSortInfo() {
        }
    }

    protected static final class ListPageInfo {
        public int firstItemIndex = 0;
        public int itemCount = 0;

        protected ListPageInfo() {
        }
    }
}

