/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.actionsupport;

import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.ResourceBundleTextProvider;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.TextProviderSupport;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextProviderActionSupport
extends TextProviderSupport {
    private static Map<Locale, Map<String, String>> maps = new Hashtable<Locale, Map<String, String>>();
    protected static Logger log = LoggerFactory.getLogger(TextProviderActionSupport.class);
    private static final String INVALID_TEXT = "NO_TEXT";
    private LocaleProvider aLocaleProvider;
    private static boolean cachingEnabled = true;

    public static void setCachingEnabled(boolean enable) {
        cachingEnabled = enable;
        if (cachingEnabled) {
            log.info(TextProviderActionSupport.class.getName() + ": Ccaching has been enabled.");
        } else {
            log.warn(TextProviderActionSupport.class.getName() + ": Caching is NOT enabled for Application!");
        }
    }

    private TextProviderActionSupport(LocaleProvider provider) {
        this.aLocaleProvider = provider;
        this.setLocaleProvider(provider);
    }

    public static TextProvider getInstance(Class<?> clazz, LocaleProvider provider) {
        TextProviderActionSupport instance = new TextProviderActionSupport(provider);
        if (instance instanceof ResourceBundleTextProvider) {
            ((ResourceBundleTextProvider)instance).setClazz(clazz);
        }
        return instance;
    }

    public static boolean isCachingEnabled() {
        return cachingEnabled;
    }

    public String getText(String key, String defaultValue, List<Object> args) {
        if (key == null) {
            log.debug("NULL key supplied to TextProviderActionSupport, NULL is not permitted!");
            return INVALID_TEXT;
        }
        if (cachingEnabled && (args == null || args.size() == 0)) {
            Map<String, String> map = this.getMap(this.aLocaleProvider.getLocale());
            if (map.containsKey(key)) {
                return map.get(key);
            }
            String value = super.getText(key, defaultValue, args);
            if (value == null) {
                log.debug("NULL value returned in TextProviderActionSupport, NULL is not permitted!");
                return INVALID_TEXT;
            }
            map.put(key, value);
            return value;
        }
        return super.getText(key, defaultValue, args);
    }

    private Map<String, String> getMap(Locale l) {
        Map<String, String> map = maps.get(l);
        if (map == null) {
            map = new Hashtable<String, String>();
            maps.put(l, map);
        }
        return map;
    }
}

