/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.interceptors;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import org.apache.empire.struts2.action.ActionAccessValidator;
import org.apache.empire.struts2.interceptors.InterceptorSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionAccessInterceptor
extends InterceptorSupport {
    protected static Logger log = LoggerFactory.getLogger(ActionAccessInterceptor.class);
    private String loginAction = null;
    private String accessDeniedAction = null;

    public void setLoginAction(String loginAction) {
        this.loginAction = loginAction;
    }

    public void setAccessDeniedAction(String accessDeniedAction) {
        this.accessDeniedAction = accessDeniedAction;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (action instanceof ActionAccessValidator) {
            ActionProxy proxy;
            if (this.loginAction != null && ((ActionAccessValidator)action).loginRequired()) {
                if (log.isWarnEnabled()) {
                    log.warn("Access to action " + action.getClass().getName() + " requires user login. Redirecting to " + this.loginAction);
                }
                return this.redirect(this.loginAction, true);
            }
            if (this.accessDeniedAction != null && !((ActionAccessValidator)action).hasAccess((proxy = invocation.getProxy()).getMethod())) {
                if (log.isWarnEnabled()) {
                    log.warn("Access to action " + action.getClass().getName() + " method " + proxy.getMethod() + " has been denied. Redirecting to " + this.accessDeniedAction);
                }
                return this.redirect(this.accessDeniedAction, true);
            }
        }
        return invocation.invoke();
    }
}

