/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.interceptors;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import javax.servlet.http.HttpServletRequest;
import org.apache.empire.struts2.action.Disposable;
import org.apache.empire.struts2.action.ExceptionAware;
import org.apache.empire.struts2.interceptors.InterceptorSupport;
import org.apache.struts2.ServletActionContext;

public class ActionBasicsInterceptor
extends InterceptorSupport {
    public final String RENDER_ACTION_RESULT = "RENDER_ACTION_RESULT";
    private String errorAction = null;

    public void setErrorAction(String errorAction) {
        this.errorAction = errorAction;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        String result = null;
        try {
            if (log.isInfoEnabled()) {
                log.info("Processing action " + action.getClass().getName() + " for uri= " + ServletActionContext.getRequest().getRequestURI());
            }
            HttpServletRequest req = ServletActionContext.getRequest();
            req.setAttribute("action", action);
            if (action instanceof Disposable) {
                ((Disposable)action).init();
            }
            result = invocation.invoke();
            return result;
        }
        catch (Exception e) {
            ActionProxy proxy = invocation.getProxy();
            log.error("An exception occurred while processing the action " + proxy.getActionName() + "!" + proxy.getMethod(), (Throwable)e);
            if (action instanceof ExceptionAware && (result = ((ExceptionAware)action).handleException(e, proxy.getMethod())) != null && result.length() > 0) {
                return result;
            }
            if (this.errorAction != null && this.errorAction.length() > 0) {
                return this.redirect(this.errorAction, true);
            }
            throw e;
        }
    }
}

