/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.components;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.components.ControlComponent;
import org.apache.empire.struts2.jsp.components.info.CalendarInfo;
import org.apache.struts2.components.Component;
import org.apache.struts2.components.ComponentUrlProvider;
import org.apache.struts2.components.UIBean;
import org.apache.struts2.components.UrlProvider;
import org.apache.struts2.components.UrlRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarComponent
extends UIBean {
    protected static Logger log = LoggerFactory.getLogger(ControlComponent.class);
    protected UrlRenderer urlRenderer;
    private CalendarInfo calendarInfo = null;
    private String selectDateAction = null;
    private String selectWeekdayAction = null;
    private String selectWeekAction = null;
    private String selectMonthAction = null;
    private String cellpadding = null;
    private String cellspacing = null;
    private String monthClass;
    private String dayOfWeekClass;
    private String weekOfYearClass;
    private String dateEmptyClass;
    private String dateValidClass;
    private String dateLinkClass;
    private String dateTodayClass;
    private String dateSelectedClass;
    private String paramName = "item";

    public CalendarComponent(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    protected String getDefaultTemplate() {
        return null;
    }

    public boolean start(Writer writer) {
        return super.start(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean end(Writer writer, String body) {
        try {
            HtmlWriter htmlWriter = new HtmlWriter(writer);
            HtmlWriter.HtmlTag table = htmlWriter.startTag("table");
            table.addAttribute("id", this.id);
            table.addAttribute("class", this.cssClass);
            table.addAttribute("style", this.cssStyle);
            table.addAttribute("cellpadding", this.cellpadding);
            table.addAttribute("cellspacing", this.cellspacing);
            table.beginBody();
            this.renderHeader(htmlWriter);
            this.renderBody(htmlWriter);
            table.endTag();
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.error("error when rendering", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.popComponentStack();
        }
    }

    private void renderHeader(HtmlWriter writer) {
        HtmlWriter.HtmlTag monthHeader = writer.startTag("tr");
        monthHeader.beginBody();
        HtmlWriter.HtmlTag thMonth = writer.startTag("th");
        thMonth.addAttribute("class", this.monthClass);
        thMonth.addAttribute("colspan", 8);
        thMonth.beginBody();
        String item = this.calendarInfo.getLinkText();
        String text = this.calendarInfo.getMonthText() + " " + this.calendarInfo.getYearText();
        if (this.selectMonthAction != null) {
            this.renderLink(writer, text, this.selectMonthAction, this.paramName, item);
            text = null;
        }
        thMonth.endTag(text);
        monthHeader.endTag();
        HtmlWriter.HtmlTag weekHeader = writer.startTag("tr");
        weekHeader.beginBody();
        HtmlWriter.HtmlTag kwHead = writer.startTag("th");
        kwHead.addAttribute("class", this.dayOfWeekClass);
        kwHead.beginBody();
        kwHead.endTag("KW");
        for (int i = 0; i < 7; ++i) {
            HtmlWriter.HtmlTag thWeekDays = writer.startTag("th");
            thWeekDays.addAttribute("class", this.dayOfWeekClass);
            thWeekDays.beginBody();
            text = this.calendarInfo.getDayOfWeekText(i);
            if (this.selectWeekdayAction != null) {
                this.renderLink(writer, text, this.selectWeekdayAction, this.paramName, item);
                text = null;
            }
            thWeekDays.endTag(text);
        }
        weekHeader.endTag();
    }

    private void renderBody(HtmlWriter writer) {
        for (int i = 0; i < this.calendarInfo.getWeekCount(); ++i) {
            HtmlWriter.HtmlTag weekRow = writer.startTag("tr");
            weekRow.beginBody();
            this.renderKalendarWeek(this.calendarInfo.getWeek(i), writer);
            for (CalendarInfo.CalendarDayInfo day : this.calendarInfo.getWeek(i)) {
                this.renderDay(day, writer);
            }
            weekRow.endTag();
        }
    }

    private void renderKalendarWeek(CalendarInfo.CalendarDayInfo[] week, HtmlWriter writer) {
        int kw = this.calendarInfo.getKalendarWeek(week);
        String bodyText = kw != 0 ? kw + "" : "";
        String linkItem = "";
        for (int i = 0; i < week.length; ++i) {
            if (week[i] == null) continue;
            linkItem = week[i].getLinkText();
            break;
        }
        HtmlWriter.HtmlTag weekCell = writer.startTag("td");
        weekCell.addAttribute("class", this.weekOfYearClass);
        weekCell.beginBody();
        if (StringUtils.isNotEmpty((String)bodyText) && StringUtils.isNotEmpty((String)this.selectWeekAction)) {
            this.renderLink(writer, bodyText, this.selectWeekAction, this.paramName, linkItem);
        } else {
            weekCell.endTag("");
        }
    }

    private void renderDay(CalendarInfo.CalendarDayInfo day, HtmlWriter writer) {
        String bodyText = null;
        String linkItem = null;
        String cssClass = null;
        if (day != null) {
            bodyText = day.getText();
            cssClass = day.isToday() ? this.dateTodayClass : (day.isSelected() ? this.dateSelectedClass : this.dateValidClass);
            if (day.isLink() && this.selectDateAction != null) {
                linkItem = day.getLinkText();
                if (!day.isSelected() && !day.isToday()) {
                    cssClass = this.dateLinkClass;
                }
            }
        } else {
            bodyText = "&nbsp;";
            cssClass = this.dateEmptyClass;
        }
        HtmlWriter.HtmlTag dateCell = writer.startTag("td");
        dateCell.addAttribute("class", cssClass);
        dateCell.beginBody();
        if (linkItem != null) {
            this.renderLink(writer, bodyText, this.selectDateAction, this.paramName, linkItem);
            bodyText = null;
        }
        dateCell.endTag(bodyText);
    }

    private void renderLink(HtmlWriter writer, String text, String action, String param, String value) {
        LinkedHashMap<String, Object> paramMap = null;
        if (param != null) {
            paramMap = new LinkedHashMap<String, Object>();
            paramMap.put(param, value);
        }
        HtmlWriter.HtmlTag link = writer.startTag("a");
        link.addAttribute("href", this.getUrl(action, paramMap));
        link.beginBody(text);
        link.endTag();
    }

    public String getUrl(String actionName, Map<String, Object> params) {
        if (actionName.startsWith("javascript:")) {
            return actionName;
        }
        ComponentUrlProvider urlProvider = new ComponentUrlProvider((Component)this, params);
        urlProvider.setHttpServletRequest(this.request);
        urlProvider.setHttpServletResponse(this.response);
        urlProvider.setUrlRenderer(this.urlRenderer);
        urlProvider.setAction(actionName);
        StringWriter sw = new StringWriter();
        this.urlRenderer.beforeRenderUrl((UrlProvider)urlProvider);
        this.urlRenderer.renderUrl((Writer)sw, (UrlProvider)urlProvider);
        String url = sw.toString();
        return url;
    }

    @Inject
    public void setUrlRenderer(UrlRenderer urlRenderer) {
        this.urlRenderer = urlRenderer;
    }

    public void setCalendarInfo(CalendarInfo calendarInfo) {
        this.calendarInfo = calendarInfo;
    }

    public void setSelectDateAction(String selectDateAction) {
        this.selectDateAction = selectDateAction;
    }

    public void setSelectWeekdayAction(String selectWeekdayAction) {
        this.selectWeekdayAction = selectWeekdayAction;
    }

    public void setSelectWeekAction(String selectWeekAction) {
        this.selectWeekAction = selectWeekAction;
    }

    public void setSelectMonthAction(String selectMonthAction) {
        this.selectMonthAction = selectMonthAction;
    }

    public void setCellpadding(String cellpadding) {
        this.cellpadding = cellpadding;
    }

    public void setCellspacing(String cellspacing) {
        this.cellspacing = cellspacing;
    }

    public void setDateEmptyClass(String dateEmptyClass) {
        this.dateEmptyClass = dateEmptyClass;
    }

    public void setDateLinkClass(String dateLinkClass) {
        this.dateLinkClass = dateLinkClass;
    }

    public void setDateSelectedClass(String dateSelectedClass) {
        this.dateSelectedClass = dateSelectedClass;
    }

    public void setDateTodayClass(String dateTodayClass) {
        this.dateTodayClass = dateTodayClass;
    }

    public void setDateValidClass(String dateValidClass) {
        this.dateValidClass = dateValidClass;
    }

    public void setDayOfWeekClass(String dayOfWeekClass) {
        this.dayOfWeekClass = dayOfWeekClass;
    }

    public void setWeekOfYearClass(String weekOfYearClass) {
        this.weekOfYearClass = weekOfYearClass;
    }

    public void setMonthClass(String monthClass) {
        this.monthClass = monthClass;
    }

    public void setParamName(String paramName) {
        if (StringUtils.isNotEmpty((String)paramName)) {
            this.paramName = paramName;
        }
    }
}

