/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.components;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.components.ControlComponent;
import org.apache.empire.struts2.jsp.controls.InputControl;
import org.apache.struts2.components.Component;
import org.apache.struts2.components.ComponentUrlProvider;
import org.apache.struts2.components.UrlProvider;
import org.apache.struts2.components.UrlRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataValueComponent
extends ControlComponent {
    protected static Logger log = LoggerFactory.getLogger(DataValueComponent.class);
    protected UrlRenderer urlRenderer;
    private String htmlTag;
    private String action;
    private String urlType;
    private Object alt;
    private String anchorClass;

    public DataValueComponent(InputControl control, ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        super(control, stack, req, res);
    }

    public String getURL() {
        if (this.action.startsWith("javascript:")) {
            return this.action;
        }
        ComponentUrlProvider urlProvider = new ComponentUrlProvider((Component)this, this.parameters);
        urlProvider.setHttpServletRequest(this.request);
        urlProvider.setHttpServletResponse(this.response);
        urlProvider.setUrlRenderer(this.urlRenderer);
        urlProvider.setPortletUrlType(this.urlType);
        urlProvider.setAction(this.action);
        StringWriter sw = new StringWriter();
        this.urlRenderer.beforeRenderUrl((UrlProvider)urlProvider);
        this.urlRenderer.renderUrl((Writer)sw, (UrlProvider)urlProvider);
        String url = sw.toString();
        return url;
    }

    @Inject
    public void setUrlRenderer(UrlRenderer urlRenderer) {
        this.urlRenderer = urlRenderer;
    }

    public void setParam(String key, String value) {
        if (value == null) {
            log.error("Action parameter '" + key + "' cannot be set to null!");
            return;
        }
        this.parameters.put(key, value);
    }

    @Override
    protected void render(HtmlWriter hw, String body, InputControl control) {
        HtmlWriter.HtmlTag td = hw.startTag(this.htmlTag);
        td.addAttribute("class", this.cssClass);
        td.addAttribute("style", this.cssStyle);
        td.beginBody();
        HtmlWriter.HtmlTag anchor = null;
        if (this.action != null) {
            String url = this.getURL();
            anchor = hw.startTag("a");
            anchor.addAttribute("href", url);
            anchor.addAttribute("title", this.alt);
            anchor.addAttribute("class", this.anchorClass);
            anchor.addAttribute("onclick", this.onclick);
            anchor.beginBody();
        }
        if (this.usesBody() && !"append".equalsIgnoreCase(this.bodyUsage)) {
            hw.print(body);
        }
        control.renderText(hw, this);
        if (this.usesBody() && "append".equalsIgnoreCase(this.bodyUsage)) {
            hw.print(body);
        }
        if (anchor != null) {
            anchor.endTag();
        }
        td.endTag();
    }

    public void setHtmlTag(String htmlTag) {
        this.htmlTag = htmlTag;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setUrlType(String urlType) {
        this.urlType = urlType;
    }

    public void setAnchorClass(String anchorClass) {
        this.anchorClass = anchorClass;
    }

    public void setAlt(Object alt) {
        this.alt = alt;
    }
}

