/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.components.info;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.empire.commons.DateUtils;
import org.apache.empire.struts2.jsp.components.ControlComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarInfo {
    protected static Logger log = LoggerFactory.getLogger(ControlComponent.class);
    private static final String DATE_FORMAT = "yyyyMMdd";
    private Locale locale;
    private CalendarDayInfo[][] days = new CalendarDayInfo[6][7];
    private int year;
    private int month;
    private Date date = null;
    private String[] months;
    private String[] weekdays;

    public static String formatDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        return dateFormat.format(date);
    }

    public static Date parseDate(String date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        if (date == null || date.length() != dateFormat.toPattern().length()) {
            log.error("Invalid date format: " + String.valueOf(date));
            return DateUtils.getDateNow();
        }
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            log.error("Invalid date format: " + date, (Throwable)e);
            return DateUtils.getDateNow();
        }
    }

    public CalendarInfo(Locale locale) {
        this.locale = locale;
        SimpleDateFormat sdf = new SimpleDateFormat("", locale);
        this.months = sdf.getDateFormatSymbols().getMonths();
        this.weekdays = sdf.getDateFormatSymbols().getShortWeekdays();
    }

    public void init(int year, int month) {
        this.year = year;
        this.month = month;
        Calendar calendar = Calendar.getInstance(this.locale);
        calendar.setFirstDayOfWeek(2);
        Date today = DateUtils.getDateNow();
        calendar.set(year, month, 1, 0, 0, 0);
        calendar.set(14, 0);
        this.date = calendar.getTime();
        for (int w = 0; w < this.days.length; ++w) {
            int dayOfWeek;
            for (int d = dayOfWeek = this.getDayOfWeek(calendar); d < this.days[w].length; ++d) {
                Date date = calendar.getTime();
                String sDay = "&nbsp;" + String.valueOf(calendar.get(5)) + "&nbsp;";
                this.days[w][d] = new CalendarDayInfo(date, sDay, date.equals(today));
                calendar.add(5, 1);
                if (month == calendar.get(2)) continue;
                return;
            }
        }
    }

    public int getWeekCount() {
        return this.days.length;
    }

    public CalendarDayInfo[] getWeek(int i) {
        return this.days[i];
    }

    public CalendarDayInfo getDayInfo(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(this.locale);
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date = cal.getTime();
        for (int w = 0; w < this.days.length; ++w) {
            for (int d = 0; d < this.days[w].length; ++d) {
                CalendarDayInfo cdi = this.days[w][d];
                if (cdi == null || !cdi.date.equals(date)) continue;
                return cdi;
            }
        }
        return null;
    }

    public boolean getLink(Date date) {
        CalendarDayInfo cdi = this.getDayInfo(date);
        return cdi != null ? Boolean.valueOf(cdi.link) : null;
    }

    public void setLink(Date date, boolean link) {
        CalendarDayInfo cdi = this.getDayInfo(date);
        if (cdi != null) {
            cdi.setLink(link);
        }
    }

    public void setSelected(boolean selected) {
        for (int w = 0; w < this.days.length; ++w) {
            for (int d = 0; d < this.days[w].length; ++d) {
                if (this.days[w][d] == null) continue;
                this.days[w][d].setSelected(selected);
            }
        }
    }

    public void setSelected(Date date, boolean selected) {
        CalendarDayInfo cdi = this.getDayInfo(date);
        if (cdi != null) {
            cdi.setSelected(selected);
        }
    }

    public void setSelected(int kalendarWeek, boolean selected) {
        int kw = 0;
        for (int w = 0; w < this.days.length; ++w) {
            kw = this.getKalendarWeek(this.days[w]);
            if (kw == 0 || kalendarWeek != kw) continue;
            this.setSelected(this.days[w], selected);
        }
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public String getLinkText() {
        return CalendarInfo.formatDate(this.date);
    }

    public String getMonthText() {
        return this.month >= 0 && this.month < this.months.length ? this.months[this.month] : "";
    }

    public String getYearText() {
        return String.valueOf(this.year);
    }

    public String getDayOfWeekText(int day) {
        if (day == 6) {
            return this.weekdays[1];
        }
        return this.weekdays[day + 2];
    }

    public int getKalendarWeek(CalendarDayInfo[] week) {
        CalendarDayInfo validDay = null;
        int retVal = 0;
        for (int i = 0; week != null && i < week.length; ++i) {
            validDay = week[i];
            if (validDay == null) continue;
            retVal = DateUtils.getWeekOfYear((Date)validDay.getDate(), (Locale)this.locale);
            break;
        }
        return retVal;
    }

    private int getDayOfWeek(Calendar c) {
        int dayOfWeek = c.get(7);
        dayOfWeek = dayOfWeek == 1 ? 6 : (dayOfWeek -= 2);
        return dayOfWeek;
    }

    private void setSelected(CalendarDayInfo[] week, boolean selected) {
        for (int d = 0; d < week.length; ++d) {
            if (week[d] == null) continue;
            week[d].setSelected(selected);
        }
    }

    public static class CalendarDayInfo {
        private Date date;
        private boolean link;
        private boolean selected;
        private boolean today;
        private String text;

        public CalendarDayInfo(Date date, String text, boolean isToday) {
            this.date = date;
            this.text = text;
            this.link = false;
            this.today = isToday;
        }

        public Date getDate() {
            return this.date;
        }

        public boolean isToday() {
            return this.today;
        }

        public String getText() {
            return this.text;
        }

        public String getLinkText() {
            return CalendarInfo.formatDate(this.date);
        }

        public boolean isLink() {
            return this.link;
        }

        public void setLink(boolean link) {
            this.link = link;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

