/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.controls;

import java.util.Locale;
import org.apache.commons.lang.xwork.StringEscapeUtils;
import org.apache.empire.commons.ErrorType;
import org.apache.empire.commons.Options;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.struts2.action.ErrorInfo;
import org.apache.empire.struts2.action.RequestParamProvider;
import org.apache.empire.struts2.html.HtmlTagDictionary;
import org.apache.empire.struts2.html.HtmlWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InputControl {
    protected static Logger log = LoggerFactory.getLogger(InputControl.class);
    public static final String NUMBER_FORMAT_ATTRIBUTE = "numberFormat";
    public static final String NUMBER_GROUPSEP_ATTRIBUTE = "numberGroupSeparator";
    public static final String NUMBER_FRACTION_DIGITS = "numberFractionDigits";
    public static final String MINVALUE_ATTRIBUTE = "minValue";
    public static final String MAXVALUE_ATTRIBUTE = "maxValue";
    public static final String CURRENCY_CODE_ATTRIBUTE = "currencyCode";
    public static final String FILE_DATA_COLUMN_ATTRIBUTE = "fileDataColumn";
    public static final Object NO_VALUE = null;
    public static final Object NULL_VALUE = "";

    protected final FieldValueError error(ErrorType errorType, String[] msgParams, String value) {
        return new FieldValueError(errorType, msgParams, value);
    }

    protected final FieldValueError error(ErrorType errorType, Object msgParam, String value) {
        return this.error(errorType, new String[]{StringUtils.toString((Object)msgParam)}, value);
    }

    public boolean useLabelId() {
        return true;
    }

    public Object getFieldValue(String name, RequestParamProvider request, Locale locale, Column column) {
        String value = request.getRequestParam(name);
        if (value == null) {
            return NO_VALUE;
        }
        if ((value = value.trim()).length() == 0) {
            return NULL_VALUE;
        }
        Object object = this.parseValue(value, locale, column);
        if (object instanceof FieldValueError) {
            return object;
        }
        return this.validate(object, locale, column, value);
    }

    public void renderText(HtmlWriter writer, ValueInfo vi) {
        if (vi instanceof ControlInfo) {
            ControlInfo ci = (ControlInfo)vi;
            HtmlTagDictionary dic = HtmlTagDictionary.getInstance();
            HtmlWriter.HtmlTag div = writer.startTag(dic.InputReadOnlyDataWrapperTag());
            div.addAttribute("id", ci.getId());
            div.addAttribute("class", ci.getCssClass());
            div.addAttribute("style", ci.getCssStyle());
            div.beginBody();
            this.internalRenderText(writer, vi);
            div.endTag();
        } else {
            this.internalRenderText(writer, vi);
        }
    }

    public abstract void renderInput(HtmlWriter var1, ControlInfo var2);

    protected void internalRenderText(HtmlWriter writer, ValueInfo vi) {
        this.printText(writer, this.formatValue(vi), "&nbsp;");
    }

    protected final void printText(HtmlWriter writer, String text, String defaultValue) {
        writer.print(text != null && text.length() > 0 ? text : defaultValue);
    }

    protected Object parseValue(String value, Locale locale, Column column) {
        return value;
    }

    protected Object validate(Object value, Locale locale, Column column, String s) {
        return value;
    }

    protected String formatValue(Object value, ValueInfo vi, boolean hasError) {
        Options options = vi.getOptions();
        if (options != null && !options.isEmpty()) {
            String text = options.get(value);
            if (text != null) {
                return vi.getTranslation(text);
            }
            log.error("The element '" + String.valueOf(value) + "' is not part of the supplied option list.");
        }
        if (value == null) {
            value = vi.getNullValue();
        }
        String s = StringUtils.valueOf((Object)value);
        if (this.hasFormatOption(vi, "noencode")) {
            return s;
        }
        return StringEscapeUtils.escapeHtml((String)s);
    }

    protected final String formatValue(ValueInfo vi) {
        boolean hasError = vi instanceof ControlInfo && ((ControlInfo)vi).hasError();
        return this.formatValue(vi.getValue(), vi, hasError);
    }

    protected boolean hasFormatOption(ValueInfo vi, String option) {
        String format = vi.getFormat();
        return format != null ? format.indexOf(option) >= 0 : false;
    }

    protected String getFormatOption(ValueInfo vi, String option) {
        String format = vi.getFormat();
        if (format == null) {
            return null;
        }
        int beg = format.indexOf(option);
        if (beg < 0) {
            return null;
        }
        int end = format.indexOf(59, (beg += option.length()) + 1);
        if (end < beg) {
            return format.substring(beg);
        }
        return format.substring(beg, end);
    }

    public static final class FieldValueError
    implements ErrorInfo {
        private ErrorType errType;
        private String[] errParams;
        private String errValue;

        public FieldValueError(ErrorType errorType, String[] msgParams, String value) {
            this.errType = errorType;
            this.errParams = msgParams;
            this.errValue = value;
        }

        @Override
        public ErrorType getErrorType() {
            return this.errType;
        }

        public String getValue() {
            return this.errValue;
        }

        @Override
        public String[] getErrorParams() {
            return this.errParams;
        }

        @Override
        public String getErrorMessage() {
            return null;
        }
    }

    public static interface ControlInfo
    extends ValueInfo {
        public String getName();

        public boolean hasError();

        public boolean getDisabled();

        public int getHSize();

        public int getVSize();

        public String getTabindex();

        public String getOnchange();

        public String getOnfocus();

        public String getOnblur();
    }

    public static interface ValueInfo {
        public Column getColumn();

        public Options getOptions();

        public Object getValue();

        public Object getNullValue();

        public Locale getUserLocale();

        public String getFormat();

        public String getOnclick();

        public String getOndblclick();

        public String getTranslation(String var1);

        public String getCssClass();

        public String getCssStyle();

        public String getId();
    }
}

