/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.controls;

import java.util.Locale;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.data.Column;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.controls.InputControl;
import org.apache.empire.struts2.web.FieldErrors;

public class PasswordInputControl
extends InputControl {
    public static final String PASSWORD_NOT_CHANGED = "********";

    private int getMinPasswordLength() {
        return 6;
    }

    @Override
    protected Object parseValue(String value, Locale locale, Column column) {
        if (value.equals(PASSWORD_NOT_CHANGED)) {
            return NO_VALUE;
        }
        return value;
    }

    @Override
    protected Object validate(Object value, Locale locale, Column column, String s) {
        String pwd = StringUtils.toString((Object)value);
        int minLength = this.getMinPasswordLength();
        if (pwd != null && pwd.length() < minLength) {
            return this.error(FieldErrors.InputTextTooShort, minLength, s);
        }
        return value;
    }

    @Override
    protected String formatValue(Object value, InputControl.ValueInfo vi, boolean hasError) {
        String pwd = StringUtils.toString((Object)value);
        if (hasError) {
            return "";
        }
        return StringUtils.isNotEmpty((String)pwd) ? PASSWORD_NOT_CHANGED : null;
    }

    @Override
    public void renderInput(HtmlWriter writer, InputControl.ControlInfo ci) {
        HtmlWriter.HtmlTag input = writer.startTag("input");
        input.addAttribute("type", "password");
        input.addAttribute("id", ci.getId());
        input.addAttribute("class", ci.getCssClass());
        input.addAttribute("style", ci.getCssStyle());
        if (!ci.getDisabled()) {
            input.addAttribute("name", ci.getName());
            int maxLength = (int)ci.getColumn().getSize();
            if (maxLength > 0) {
                input.addAttribute("maxlength", maxLength);
                input.addAttribute("size", String.valueOf(Math.min(maxLength, ci.getHSize())));
            }
        } else {
            input.addAttribute("disabled");
            int maxLength = (int)ci.getColumn().getSize();
            if (maxLength > 0) {
                input.addAttribute("size", String.valueOf(Math.min(maxLength, ci.getHSize())));
            }
        }
        input.addAttribute("value", this.formatValue(ci));
        input.addAttribute("onclick", ci.getOnclick());
        input.addAttribute("onchange", ci.getOnchange());
        input.addAttribute("onfocus", ci.getOnfocus());
        input.addAttribute("onblur", ci.getOnblur());
        input.endTag();
    }
}

