/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.controls;

import org.apache.empire.commons.ObjectUtils;
import org.apache.empire.commons.OptionEntry;
import org.apache.empire.commons.Options;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.controls.InputControl;

public class SelectInputControl
extends InputControl {
    @Override
    public void renderInput(HtmlWriter writer, InputControl.ControlInfo ci) {
        boolean disabled = ci.getDisabled();
        HtmlWriter.HtmlTag input = writer.startTag("select");
        input.addAttribute("id", ci.getId());
        input.addAttribute("class", ci.getCssClass());
        input.addAttribute("style", ci.getCssStyle());
        if (disabled) {
            input.addAttribute("disabled");
        } else {
            input.addAttribute("name", ci.getName());
        }
        input.addAttribute("onclick", ci.getOnclick());
        input.addAttribute("onchange", ci.getOnchange());
        input.addAttribute("onfocus", ci.getOnfocus());
        input.addAttribute("onblur", ci.getOnblur());
        input.beginBody(true);
        Options options = ci.getOptions();
        if (options != null) {
            Object current = ci.getValue();
            if (this.hasFormatOption(ci, "allownull") && !options.contains(null)) {
                this.addEmtpyEntry(writer, ObjectUtils.isEmpty((Object)current));
            }
            for (OptionEntry entry : options) {
                Object value = entry.getValue();
                boolean isCurrent = ObjectUtils.compareEqual((Object)current, (Object)value);
                if (!isCurrent && disabled) continue;
                HtmlWriter.HtmlTag option = writer.startTag("option");
                option.addAttributeNoCheck("value", value, true);
                option.addAttribute("selected", isCurrent);
                option.beginBody(ci.getTranslation(entry.getText()));
                option.endTag(true);
            }
        } else {
            log.error("No options available for select input control.");
        }
        input.endTag();
    }

    private void addEmtpyEntry(HtmlWriter writer, boolean isCurrent) {
        HtmlWriter.HtmlTag option = writer.startTag("option");
        option.addAttributeNoCheck("value", "", false);
        option.addAttribute("selected", isCurrent);
        option.beginBody("");
        option.endTag(true);
    }
}

