/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.tags;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.TextProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.empire.commons.StringUtils;
import org.apache.empire.struts2.action.ActionItemProperty;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.struts2.components.UIBean;
import org.apache.struts2.views.jsp.ComponentTagSupport;
import org.apache.struts2.views.util.UrlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EmpireTagSupport
extends ComponentTagSupport {
    protected static Logger log = LoggerFactory.getLogger(EmpireTagSupport.class);
    protected boolean autoResetParams = true;
    protected String cssClass;
    protected String cssStyle;

    protected void resetParams() {
        this.id = null;
        this.cssClass = null;
        this.cssStyle = null;
    }

    public final void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public final void setCssStyle(String cssStyle) {
        this.cssStyle = cssStyle;
    }

    public final void setId(String id) {
        super.setId(id);
    }

    public String getId() {
        return this.getString(this.id);
    }

    protected void populateParams() {
        super.populateParams();
        if (this.component instanceof UIBean) {
            ((UIBean)this.component).setCssClass(this.cssClass);
            ((UIBean)this.component).setCssStyle(this.cssStyle);
        }
    }

    public int doEndTag() throws JspException {
        if (this.autoResetParams) {
            this.resetParams();
        }
        return super.doEndTag();
    }

    public void release() {
        log.debug("Releasing tag " + ((Object)((Object)this)).getClass().getName());
        this.resetParams();
        super.release();
    }

    protected void addStandardAttributes(HtmlWriter.HtmlTag tag, String defaultClass) {
        tag.addAttribute("id", this.getId());
        tag.addAttribute("class", this.str(this.cssClass, defaultClass));
        tag.addAttribute("style", this.cssStyle);
        this.cssClass = null;
        this.cssStyle = null;
        this.setId(null);
    }

    protected Object getAction() {
        try {
            return ActionContext.getContext().getActionInvocation().getAction();
        }
        catch (Exception e) {
            log.error("Unable to detect Action. Action Invocation not available!");
            return "";
        }
    }

    protected String getActionName() {
        try {
            return ActionContext.getContext().getActionInvocation().getProxy().getActionName();
        }
        catch (Exception e) {
            log.error("Unable to detect Action name. Action Invocation Proxy not available!");
            return "";
        }
    }

    protected String getActionItemPropertyName() {
        Object action = this.getAction();
        if (action instanceof ActionItemProperty) {
            return ((ActionItemProperty)action).getItemPropertyName();
        }
        return "item";
    }

    protected String getActionURL(String action, Map parameters) {
        HttpServletRequest httpRequest = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse httpResponse = (HttpServletResponse)this.pageContext.getResponse();
        String uri = "/" + this.checkAction(action);
        if (uri.indexOf(46) < 0) {
            uri = uri + ".action";
        }
        return UrlHelper.buildUrl((String)uri, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse, (Map)parameters, null, (boolean)true, (boolean)true);
    }

    protected Object putPageAttribute(String name, Object value) {
        Object oldValue = this.pageContext.getAttribute(name);
        this.pageContext.setAttribute(name, value);
        return oldValue;
    }

    protected void removePageAttribute(String name, Object oldValue) {
        if (oldValue != null) {
            this.pageContext.setAttribute(name, oldValue);
        } else {
            this.pageContext.removeAttribute(name);
        }
    }

    protected Object getPageAttribute(String name, Object defValue) {
        Object o = this.pageContext.getAttribute(name);
        return o != null ? o : defValue;
    }

    protected String str(String value, String defValue) {
        return value != null ? value : defValue;
    }

    protected Object getObject(Object value, Object defValue, Class<?> asType) {
        if (value == null) {
            return defValue;
        }
        if (value instanceof String) {
            String strval = value.toString();
            if (strval.startsWith("%{") && strval.endsWith("}")) {
                strval = strval.substring(2, strval.length() - 1);
                return this.getStack().findValue(strval, asType);
            }
            if (strval.startsWith("#")) {
                return this.getStack().findValue(strval, asType);
            }
            if (strval.startsWith("$")) {
                if (!(strval = strval.substring(1)).startsWith("$")) {
                    value = this.getAttribute(strval);
                }
                if (value == null) {
                    return defValue;
                }
            }
        }
        if (asType.isInstance(value)) {
            return asType.cast(value);
        }
        log.error("Cannot cast value of '" + value.toString() + " to class " + asType.toString());
        return null;
    }

    protected final Object getObject(Object value, Object defValue) {
        return this.getObject(value, defValue, Object.class);
    }

    protected String getString(Object value, String defValue) {
        if (value == null) {
            return defValue;
        }
        if (!(value instanceof String)) {
            return value.toString();
        }
        String strval = value.toString();
        if (strval.startsWith("%{") && strval.endsWith("}")) {
            strval = strval.substring(2, strval.length() - 1);
            return (String)this.getStack().findValue(strval, String.class);
        }
        if (strval.startsWith("#")) {
            return (String)this.getStack().findValue(strval, String.class);
        }
        if (strval.startsWith("$") && !(strval = strval.substring(1)).startsWith("$")) {
            return StringUtils.toString((Object)this.getAttribute(strval));
        }
        if (strval.startsWith("!") && !(strval = strval.substring(1)).startsWith("!")) {
            return this.getTranslationFromKey(this.getString((Object)strval, null));
        }
        return strval;
    }

    protected final String getString(Object value) {
        return this.getString(value, null);
    }

    protected final String getString(Object value, Object defValue) {
        String defValStr = defValue != null ? defValue.toString() : null;
        return this.getString(value, defValStr);
    }

    protected int getInt(Object value, int defValue) {
        if (value == null) {
            return defValue;
        }
        if (value instanceof String) {
            value = this.getObject(value, 0, Object.class);
        }
        if (value instanceof Number) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            return defValue;
        }
    }

    protected boolean getBoolean(Object value, boolean defValue) {
        if (value == null) {
            return defValue;
        }
        if (value instanceof String) {
            value = this.getObject(value, 0, Object.class);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String txt = String.valueOf(value);
        return txt.equalsIgnoreCase("true");
    }

    protected Object getBeanProperty(Object bean, String property) {
        try {
            PropertyUtilsBean pub = BeanUtilsBean.getInstance().getPropertyUtils();
            return pub.getSimpleProperty(bean, property);
        }
        catch (IllegalAccessException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            return null;
        }
        catch (InvocationTargetException e) {
            log.error(bean.getClass().getName() + ": unable to set property '" + property + "'");
            return null;
        }
        catch (NoSuchMethodException e) {
            log.warn(bean.getClass().getName() + ": cannot check value of property '" + property + "'");
            return null;
        }
    }

    protected String checkAction(String action) {
        if (action == null) {
            return null;
        }
        int i = action.indexOf(33);
        if (i < 0) {
            if (!action.startsWith("javascript:")) {
                log.warn("No link action method for for action " + action + " has been supplied! Page = " + this.getPageName());
            }
        } else if (i == 0) {
            return this.getActionName() + action;
        }
        return action;
    }

    protected String getPageName() {
        String page = this.pageContext.getPage().toString();
        int lastDot = page.lastIndexOf(46);
        int lastAt = page.indexOf(64);
        if (lastDot > 0 && lastDot < lastAt) {
            page = page.substring(lastDot + 1, lastAt);
        }
        return page;
    }

    protected Object getAttribute(String attribute) {
        Object obj = this.pageContext.getAttribute(attribute);
        if (obj != null) {
            return obj;
        }
        obj = this.pageContext.getRequest().getAttribute(attribute);
        if (obj != null) {
            return obj;
        }
        obj = this.pageContext.getSession().getAttribute(attribute);
        if (obj != null) {
            return obj;
        }
        return this.pageContext.getServletContext().getAttribute(attribute);
    }

    protected String getTranslation(String text) {
        if (text == null || text.length() == 0 || !text.startsWith("!")) {
            return text;
        }
        String key = text.substring(1);
        if (key.startsWith("!")) {
            return key;
        }
        return this.getTranslationFromKey(key);
    }

    private TextProvider getTextProvider(Object action) {
        if (action instanceof TextProvider) {
            return (TextProvider)action;
        }
        return null;
    }

    protected Locale getLocale(Object action) {
        if (action instanceof LocaleProvider) {
            return ((LocaleProvider)action).getLocale();
        }
        return ActionContext.getContext().getLocale();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getTranslationFromKey(String key) {
        Object action = this.getAction();
        TextProvider tp = this.getTextProvider(action);
        if (tp != null) {
            String locale = this.getLocale(action).toString();
            String result = tp.getText(key);
            if (result == null) {
                if (!log.isErrorEnabled()) return "[" + key + "]";
                log.error("No translation found for key=[" + key + "] on page " + this.getPageName() + " --> locale=" + locale);
                return "[" + key + "]";
            } else {
                if (result.length() != 0) return result;
                if (!log.isInfoEnabled()) return "[" + key + "]";
                log.info("Translation key [" + key + "] found, but value is empty! locale=" + locale);
            }
            return "[" + key + "]";
        } else {
            log.error("No text provider available. Action does not implement TextProvider interface");
        }
        return "[" + key + "]";
    }
}

