/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.tags;

import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import org.apache.empire.struts2.html.HtmlTagDictionary;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.tags.EmpireTagSupport;
import org.apache.struts2.components.Component;

public class FormSubmitTag
extends EmpireTagSupport {
    protected String text;
    protected String action;
    protected Object redirect;
    protected Object disabled;
    protected String tabindex;
    protected String onclick;
    protected Object embed;
    protected String name;

    @Override
    protected void resetParams() {
        this.text = null;
        this.name = null;
        this.action = null;
        this.disabled = null;
        this.tabindex = null;
        this.onclick = null;
        this.redirect = null;
        this.embed = null;
        super.resetParams();
    }

    public Component getBean(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        log.error("No Bean avaliable for Submit tag.");
        return null;
    }

    @Override
    protected void populateParams() {
        log.error("Illegar mehtod call.");
    }

    public int doStartTag() throws JspException {
        HtmlTagDictionary dic = HtmlTagDictionary.getInstance();
        HtmlWriter w = new HtmlWriter((Writer)this.pageContext.getOut());
        if (this.getBoolean(this.embed, false)) {
            HtmlWriter.HtmlTag wrapper = w.startTag(dic.InputWrapperTag());
            wrapper.addAttribute("class", dic.InputWrapperClass());
            wrapper.beginBody(true);
            HtmlWriter.HtmlTag wrapCtrl = w.startTag(dic.SubmitControlTag());
            wrapCtrl.addAttribute("class", dic.SubmitControlClass());
            wrapCtrl.addAttributes(dic.SubmitControlAttributes());
            wrapCtrl.beginBody();
        }
        this.renderButtonStart(w);
        return 1;
    }

    @Override
    public int doEndTag() throws JspException {
        HtmlTagDictionary dic = HtmlTagDictionary.getInstance();
        HtmlWriter w = new HtmlWriter((Writer)this.pageContext.getOut());
        this.renderButtonEnd(w);
        if (this.getBoolean(this.embed, false)) {
            HtmlWriter.HtmlTag wrapCtrl = w.continueTag(dic.SubmitControlTag(), true);
            wrapCtrl.endTag();
            HtmlWriter.HtmlTag wrapper = w.continueTag(dic.InputWrapperTag(), true);
            wrapper.endTag();
        }
        this.resetParams();
        return 6;
    }

    private void renderButtonStart(HtmlWriter w) {
        HtmlWriter.HtmlTag button = w.startTag("button");
        button.addAttribute("id", this.getId());
        button.addAttribute("type", "submit");
        button.addAttribute("name", this.getButtonName());
        button.addAttribute("onclick", this.onclick);
        button.addAttribute("disabled", this.getBoolean(this.disabled, false));
        button.addAttribute("tabindex", this.getString((Object)this.tabindex, null));
        button.addAttribute("class", this.getButtonClass());
        button.addAttribute("style", this.cssStyle);
        button.beginBody(this.getString(this.text));
    }

    private void renderButtonEnd(HtmlWriter w) {
        HtmlWriter.HtmlTag menu = w.continueTag("button", true);
        menu.endTag();
    }

    private String getButtonName() {
        if (this.name != null) {
            if (this.action != null) {
                log.warn("Name is set on submit button. Action property is ignored! " + this.action);
            }
            return this.name;
        }
        if (this.action == null) {
            return null;
        }
        String call = this.getBoolean(this.redirect, false) ? "redirectAction:" : "action:";
        return call + this.checkAction(this.action);
    }

    private String getButtonClass() {
        if (this.cssClass != null) {
            return this.cssClass;
        }
        HtmlTagDictionary dic = HtmlTagDictionary.getInstance();
        return dic.SubmitClass();
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setDisabled(Object disabled) {
        this.disabled = disabled;
    }

    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    public void setTabindex(String tabindex) {
        this.tabindex = tabindex;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setRedirect(Object redirect) {
        this.redirect = redirect;
    }

    public void setEmbed(Object embed) {
        this.embed = embed;
    }

    public void setName(String name) {
        this.name = name;
    }
}

