/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.tags;

import java.io.Writer;
import java.util.Stack;
import javax.servlet.jsp.JspException;
import org.apache.empire.struts2.html.HtmlTagDictionary;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.tags.LinkTag;
import org.apache.empire.struts2.jsp.tags.MenuTag;

public class MenuItemTag
extends LinkTag {
    protected String menuId;
    protected Object expanded;

    @Override
    protected void resetParams() {
        this.menuId = null;
        this.expanded = null;
        super.resetParams();
    }

    @Override
    public int doStartTag() throws JspException {
        if (!this.getBoolean(this.visible, true)) {
            return 0;
        }
        MenuTag.MenuInfo mi = this.getMenuInfo();
        boolean current = this.isCurrent(mi);
        HtmlTagDictionary dic = HtmlTagDictionary.getInstance();
        HtmlWriter w = new HtmlWriter((Writer)this.pageContext.getOut());
        HtmlWriter.HtmlTag wrap = w.startTag("li");
        this.addStandardAttributes(wrap, null);
        this.cssClass = this.getCssClass(mi, current);
        this.cssStyle = null;
        wrap.beginBody();
        if (this.item == null && mi.actionItem != null) {
            this.item = mi.actionItem;
        }
        if (this.onclick == null) {
            this.onclick = dic.MenuItemLinkDefaultOnClickScript();
        }
        int result = super.doStartTag();
        return this.isExpanded(mi) ? result : 0;
    }

    @Override
    public int doEndTag() throws JspException {
        if (!this.getBoolean(this.visible, true)) {
            if (this.autoResetParams) {
                this.resetParams();
            }
            return 6;
        }
        String body = this.getBody();
        this.setBodyContent(null);
        int result = super.doEndTag();
        HtmlWriter w = new HtmlWriter((Writer)this.pageContext.getOut());
        HtmlWriter.HtmlTag wrap = w.continueTag("li", true);
        wrap.endTag(body);
        return result;
    }

    private MenuTag.MenuInfo getMenuInfo() {
        Stack stack = (Stack)this.pageContext.getAttribute("MenuTag.MenuInfo");
        return stack != null ? (MenuTag.MenuInfo)stack.peek() : null;
    }

    private boolean isCurrent(MenuTag.MenuInfo mi) {
        if (mi == null || mi.currentId == null) {
            return false;
        }
        String thisMenu = this.menuId != null ? this.menuId : this.id;
        return thisMenu != null ? thisMenu.equals(mi.currentId) : false;
    }

    private boolean isExpanded(MenuTag.MenuInfo mi) {
        if (this.expanded == null) {
            return true;
        }
        if (this.expanded instanceof String && "auto".equalsIgnoreCase((String)this.expanded)) {
            return this.isCurrent(mi);
        }
        return this.getBoolean(this.expanded, true);
    }

    private String getCssClass(MenuTag.MenuInfo mi, boolean current) {
        if (mi == null) {
            return null;
        }
        if (this.getBoolean(this.disabled, false)) {
            return mi.disabledClass;
        }
        if (current) {
            return mi.currentClass;
        }
        if (this.expanded != null && this.isExpanded(mi)) {
            return mi.expandedClass;
        }
        return mi.enabledClass;
    }

    public void setMenuId(String menuId) {
        this.menuId = menuId;
    }

    public void setExpanded(Object expanded) {
        this.expanded = expanded;
    }
}

