/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.jsp.tags;

import java.io.Writer;
import javax.servlet.jsp.JspException;
import org.apache.empire.data.ColumnExpr;
import org.apache.empire.struts2.html.HtmlWriter;
import org.apache.empire.struts2.jsp.tags.DataValueTag;
import org.apache.empire.struts2.jsp.tags.TableRowTag;

public class TableDataTag
extends DataValueTag {
    private static final TableRowTag.RowInfo defaultRowInfo = new TableRowTag.RowInfo();
    protected String width;
    protected String height;
    protected String colspan;
    protected String rowspan;
    protected String align;
    protected String valign;
    protected String wrap;
    protected String bgcolor;

    @Override
    protected void resetParams() {
        this.width = null;
        this.height = null;
        this.colspan = null;
        this.rowspan = null;
        this.align = null;
        this.valign = null;
        this.wrap = null;
        this.bgcolor = null;
        super.resetParams();
    }

    public int doStartTag() throws JspException {
        TableRowTag.RowInfo ri = this.getRowInfo();
        HtmlWriter w = new HtmlWriter((Writer)this.pageContext.getOut());
        HtmlWriter.HtmlTag td = w.startTag("td");
        td.addAttribute("id", this.getId());
        td.addAttribute("class", this.getCssClass(ri));
        this.setStyleAndWrap(td, ri);
        td.addAttribute("width", this.width);
        td.addAttribute("height", this.height);
        td.addAttribute("colspan", this.colspan);
        td.addAttribute("rowspan", this.rowspan);
        td.addAttribute("align", this.str(this.align, ri.columnAlign));
        td.addAttribute("valign", this.valign);
        td.addAttribute("bgcolor", this.bgcolor);
        td.beginBody();
        this.id = null;
        this.cssClass = null;
        this.cssStyle = null;
        return super.doStartTag();
    }

    @Override
    public int doEndTag() throws JspException {
        int result = super.doEndTag();
        HtmlWriter w = new HtmlWriter((Writer)this.pageContext.getOut());
        HtmlWriter.HtmlTag td = w.continueTag("td", true);
        td.endTag();
        return result;
    }

    private TableRowTag.RowInfo getRowInfo() {
        Object ri = this.getPageAttribute("tableRowInfo", null);
        if (ri instanceof TableRowTag.RowInfo) {
            return (TableRowTag.RowInfo)ri;
        }
        log.debug("No table row information available! <e:tr> Tag missing?" + this.getPageName());
        return defaultRowInfo;
    }

    private String getCssClass(TableRowTag.RowInfo ri) {
        if (this.cssClass != null) {
            return this.cssClass;
        }
        ColumnExpr column = this.getColumnExpr();
        if (ri.currentClass != null && ri.currentColumn != null && ri.currentColumn.equals(column)) {
            return ri.currentClass;
        }
        return ri.columnClass;
    }

    private void setStyleAndWrap(HtmlWriter.HtmlTag tag, TableRowTag.RowInfo ri) {
        String style = this.str(this.cssStyle, ri.columnStyle);
        String wordwrap = this.str(this.wrap, ri.columnWrap);
        if ("nowrap".equalsIgnoreCase(wordwrap)) {
            tag.addAttribute("nowrap");
        } else if (wordwrap != null && wordwrap.length() > 0) {
            wordwrap = "word-wrap: " + wordwrap + ";";
            style = style != null ? wordwrap + style : wordwrap;
        }
        tag.addAttribute("style", style);
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public void setBgcolor(String bgcolor) {
        this.bgcolor = bgcolor;
    }

    public void setColspan(String colspan) {
        this.colspan = colspan;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setWrap(String wrap) {
        this.wrap = wrap;
    }

    public void setRowspan(String rowspan) {
        this.rowspan = rowspan;
    }

    public void setValign(String valign) {
        this.valign = valign;
    }

    public void setWidth(String width) {
        this.width = width;
    }
}

