/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.struts2.web;

import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import org.apache.empire.struts2.action.Disposable;
import org.apache.empire.struts2.web.DefaultWebRequest;
import org.apache.empire.struts2.web.EmpireStrutsDispatcher;
import org.apache.empire.struts2.web.EmpireThreadManager;
import org.apache.empire.struts2.web.WebApplication;
import org.apache.empire.struts2.web.WebRequest;
import org.apache.empire.struts2.web.WebSession;
import org.apache.empire.struts2.web.portlet.PortletContextWrapper;
import org.apache.empire.struts2.web.portlet.PortletRequestWrapper;
import org.apache.empire.struts2.web.portlet.PortletResponseWrapper;
import org.apache.empire.struts2.web.portlet.PortletSessionWrapper;
import org.apache.struts2.portlet.dispatcher.Jsr168Dispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmpirePortletDispatcher
extends Jsr168Dispatcher {
    protected static Logger log = LoggerFactory.getLogger(EmpireStrutsDispatcher.class);
    public final String RENDER_DIRECT_ACTION = "struts.portlet.renderDirectAction";
    public final String APPLICATION_CLASS = "ApplicationClass";
    public final String SESSION_CLASS = "SessionClass";
    public final String REQUEST_CLASS = "RequestClass";
    private String sessionClassName = null;
    private String requestClassName = null;
    private boolean logRequestWarning = true;

    public void init(PortletConfig cfg) throws PortletException {
        super.init(cfg);
        String appClassName = cfg.getInitParameter("ApplicationClass");
        if (appClassName != null) {
            this.createApplicationObject(cfg.getPortletContext(), appClassName);
        }
        this.sessionClassName = cfg.getInitParameter("SessionClass");
        this.requestClassName = cfg.getInitParameter("RequestClass");
        if (this.requestClassName == null || this.requestClassName.length() == 0) {
            this.requestClassName = DefaultWebRequest.class.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceAction(PortletRequest request, PortletResponse response, Map<String, Object> requestMap, Map<String, String[]> parameterMap, Map<String, Object> sessionMap, Map<String, Object> applicationMap, String portletNamespace, Integer phase) throws PortletException {
        try {
            if (this.sessionClassName != null) {
                Object applObj = applicationMap.get("webApp");
                this.createSessionObject(request, applObj);
            }
            boolean continueProcessing = true;
            if (this.requestClassName != null) {
                Object sessObj = sessionMap.get("webSession");
                continueProcessing = this.createRequestObject(request, response, sessObj);
            }
            if (continueProcessing) {
                if (log.isDebugEnabled()) {
                    log.debug("starting portlet service request");
                }
                super.serviceAction(request, response, requestMap, parameterMap, sessionMap, applicationMap, portletNamespace, phase);
            }
        }
        catch (Exception e) {
            log.error("Failed to process request due to Exception.", (Throwable)e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("cleanung up request");
            }
            int exitCode = this.disposeAction(request);
            EmpireThreadManager.exit(exitCode);
        }
    }

    private int disposeAction(PortletRequest request) {
        int exitCode = 0;
        Object action = request.getAttribute("action");
        if (action != null) {
            if (action instanceof Disposable) {
                exitCode = ((Disposable)action).dispose();
            } else {
                log.warn("Cannot dispose action. Action does not implement the Disposible interface)");
            }
            request.removeAttribute("action");
        } else {
            log.warn("Cannot dispose action. Action is not supplied on the request. (Missing ActionBasicsInterceptor?)");
        }
        return exitCode;
    }

    private Object createObject(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> c = Class.forName(className);
        return c.newInstance();
    }

    protected void createApplicationObject(PortletContext portletContext, String appClassName) {
        try {
            if (portletContext.getAttribute("webApp") == null) {
                Object app = this.createObject(appClassName);
                if (app instanceof WebApplication) {
                    ((WebApplication)app).init(new PortletContextWrapper(portletContext));
                } else {
                    log.warn("Application object does not implement IWebApplication!");
                }
                portletContext.setAttribute("webApp", app);
            }
        }
        catch (Exception e) {
            log.error("Failed to create web application object of type " + appClassName + " --> " + e.getMessage());
        }
    }

    protected void createSessionObject(PortletRequest request, Object applObj) {
        try {
            PortletSession portletSession = request.getPortletSession(false);
            if (portletSession == null || portletSession.getAttribute("webSession") == null) {
                Object session = this.createObject(this.sessionClassName);
                portletSession = request.getPortletSession(true);
                if (session instanceof WebSession) {
                    ((WebSession)session).init(new PortletSessionWrapper(portletSession), applObj);
                } else {
                    log.warn("Session object does not implement IWebSession!");
                }
                portletSession.setAttribute("webSession", session);
            }
        }
        catch (Exception e) {
            log.error("Failed to create session [" + this.sessionClassName + "] msg= " + e.getMessage());
        }
    }

    protected boolean createRequestObject(PortletRequest request, PortletResponse response, Object sessObj) {
        try {
            Object reqObj = request.getAttribute("webRequest");
            if (reqObj == null) {
                reqObj = this.createObject(this.requestClassName);
                EmpireThreadManager.setCurrentRequest(reqObj);
                if (reqObj instanceof WebRequest) {
                    PortletRequestWrapper req = new PortletRequestWrapper(request);
                    PortletResponseWrapper res = new PortletResponseWrapper(response);
                    return ((WebRequest)reqObj).init(req, res, sessObj);
                }
                if (this.logRequestWarning) {
                    log.warn("Request object does not implement IWebRequest!");
                    this.logRequestWarning = false;
                }
            }
            return true;
        }
        catch (Exception e) {
            log.error("Failed to create request [" + this.requestClassName + "] msg= " + e.getMessage());
            this.requestClassName = null;
            return true;
        }
    }
}

