/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.eventmesh.client.http.conf.EventMeshHttpClientConfig;
import org.apache.eventmesh.client.http.ssl.MyX509TrustManager;
import org.apache.eventmesh.client.http.util.HttpLoadBalanceUtils;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.loadbalance.LoadBalanceSelector;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpClient.class);
    protected EventMeshHttpClientConfig eventMeshHttpClientConfig;
    protected LoadBalanceSelector<String> eventMeshServerSelector;
    protected final CloseableHttpClient httpClient;

    public AbstractHttpClient(EventMeshHttpClientConfig eventMeshHttpClientConfig) throws EventMeshException {
        Preconditions.checkNotNull((Object)eventMeshHttpClientConfig, (Object)"liteClientConfig can't be null");
        Preconditions.checkNotNull((Object)eventMeshHttpClientConfig.getLiteEventMeshAddr(), (Object)"liteServerAddr can't be null");
        this.eventMeshHttpClientConfig = eventMeshHttpClientConfig;
        this.eventMeshServerSelector = HttpLoadBalanceUtils.createEventMeshServerLoadBalanceSelector(eventMeshHttpClientConfig);
        this.httpClient = this.setHttpClient();
    }

    @Override
    public void close() throws EventMeshException {
        try {
            CloseableHttpClient ignore = this.httpClient;
            Throwable throwable = null;
            if (ignore != null) {
                if (throwable != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignore.close();
                }
            }
        }
        catch (IOException e) {
            throw new EventMeshException("Close http client error", (Throwable)e);
        }
    }

    private CloseableHttpClient setHttpClient() throws EventMeshException {
        if (!this.eventMeshHttpClientConfig.isUseTls()) {
            return HttpClients.createDefault();
        }
        try {
            String protocol = System.getProperty("ssl.client.protocol", "TLSv1.2");
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance(protocol);
            sslContext.init(null, tm, new SecureRandom());
            return HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier()).build();
        }
        catch (Exception e) {
            log.error("Error in creating HttpClient.", (Throwable)e);
            throw new EventMeshException((Throwable)e);
        }
    }

    protected String selectEventMesh() {
        if (this.eventMeshHttpClientConfig.isUseTls()) {
            return "https://" + (String)this.eventMeshServerSelector.select();
        }
        return "http://" + (String)this.eventMeshServerSelector.select();
    }
}

