/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.model;

import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestParam {
    private static final Logger log = LoggerFactory.getLogger(RequestParam.class);
    private Map<String, String[]> queryParams;
    private final HttpMethod httpMethod;
    private Map<String, String> body;
    private Map<String, String> headers;
    private long timeout = 15000L;

    public RequestParam(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public RequestParam setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, String> getBody() {
        return this.body;
    }

    public RequestParam setBody(Map<String, String> body) {
        this.body = body;
        return this;
    }

    public Map<String, String[]> getQueryParamsMap() {
        return this.queryParams;
    }

    public String getQueryParams() {
        if (this.queryParams == null || this.queryParams.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, String[]> query : this.queryParams.entrySet()) {
                for (String val : query.getValue()) {
                    stringBuilder.append("&").append(URLEncoder.encode(query.getKey(), "UTF-8"));
                    if (val == null || val.isEmpty()) continue;
                    stringBuilder.append("=").append(URLEncoder.encode(val, "UTF-8"));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("get query params failed.", (Throwable)e);
            return "";
        }
        return stringBuilder.substring(1);
    }

    public RequestParam setQueryParams(Map<String, String[]> queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public RequestParam addQueryParam(String key, String value) {
        if (this.queryParams == null) {
            this.queryParams = new HashMap<String, String[]>();
        }
        if (!this.queryParams.containsKey(key)) {
            this.queryParams.put(key, new String[]{value});
        } else {
            this.queryParams.put(key, (String[])Arrays.asList((Serializable)this.queryParams.get(key), value).toArray());
        }
        return this;
    }

    public RequestParam addHeader(String key, Object value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value.toString());
        return this;
    }

    public RequestParam addBody(String key, String value) {
        if (this.body == null) {
            this.body = new HashMap<String, String>();
        }
        this.body.put(key, value);
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public RequestParam setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }
}

