/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.http.producer;

import com.google.common.base.Preconditions;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.provider.EventFormatProvider;
import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.eventmesh.client.http.AbstractHttpClient;
import org.apache.eventmesh.client.http.EventMeshRetObj;
import org.apache.eventmesh.client.http.conf.EventMeshHttpClientConfig;
import org.apache.eventmesh.client.http.model.RequestParam;
import org.apache.eventmesh.client.http.producer.EventMeshProtocolProducer;
import org.apache.eventmesh.client.http.producer.RRCallback;
import org.apache.eventmesh.client.http.producer.RRCallbackResponseHandlerAdapter;
import org.apache.eventmesh.client.http.util.HttpUtils;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CloudEventProducer
extends AbstractHttpClient
implements EventMeshProtocolProducer<CloudEvent> {
    private static final Logger log = LoggerFactory.getLogger(CloudEventProducer.class);
    private static final String PROTOCOL_TYPE = "cloudevents";
    private static final String PROTOCOL_DESC = "http";

    public CloudEventProducer(EventMeshHttpClientConfig eventMeshHttpClientConfig) throws EventMeshException {
        super(eventMeshHttpClientConfig);
    }

    @Override
    public void publish(CloudEvent cloudEvent) throws EventMeshException {
        this.validateCloudEvent(cloudEvent);
        CloudEvent enhanceCloudEvent = this.enhanceCloudEvent(cloudEvent);
        RequestParam requestParam = this.buildCommonPostParam(enhanceCloudEvent).addHeader("code", RequestCode.MSG_SEND_ASYNC.getRequestCode());
        String target = this.selectEventMesh();
        try {
            String response = HttpUtils.post(this.httpClient, target, requestParam);
            EventMeshRetObj ret = (EventMeshRetObj)JsonUtils.deserialize((String)response, EventMeshRetObj.class);
            if (ret.getRetCode() != EventMeshRetCode.SUCCESS.getRetCode().intValue()) {
                throw new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg());
            }
        }
        catch (Exception exception) {
            throw new EventMeshException(String.format("Publish message error, target:%s", target), (Throwable)exception);
        }
    }

    @Override
    public CloudEvent request(CloudEvent cloudEvent, long timeout) throws EventMeshException {
        this.validateCloudEvent(cloudEvent);
        CloudEvent enhanceCloudEvent = this.enhanceCloudEvent(cloudEvent);
        RequestParam requestParam = this.buildCommonPostParam(enhanceCloudEvent).addHeader("code", RequestCode.MSG_SEND_SYNC.getRequestCode()).setTimeout(timeout);
        String target = this.selectEventMesh();
        try {
            String response = HttpUtils.post(this.httpClient, target, requestParam);
            EventMeshRetObj ret = (EventMeshRetObj)JsonUtils.deserialize((String)response, EventMeshRetObj.class);
            if (ret.getRetCode() == EventMeshRetCode.SUCCESS.getRetCode().intValue()) {
                return this.transformMessage(ret);
            }
            throw new EventMeshException(Integer.valueOf(ret.getRetCode()), ret.getRetMsg());
        }
        catch (Exception e) {
            throw new EventMeshException(String.format("Request message error, target:%s", target), (Throwable)e);
        }
    }

    @Override
    public void request(CloudEvent cloudEvent, RRCallback<CloudEvent> rrCallback, long timeout) throws EventMeshException {
        this.validateCloudEvent(cloudEvent);
        CloudEvent enhanceCloudEvent = this.enhanceCloudEvent(cloudEvent);
        RequestParam requestParam = this.buildCommonPostParam(enhanceCloudEvent).addHeader("code", RequestCode.MSG_SEND_SYNC.getRequestCode()).setTimeout(timeout);
        String target = this.selectEventMesh();
        RRCallbackResponseHandlerAdapter<CloudEvent> adapter = new RRCallbackResponseHandlerAdapter<CloudEvent>(enhanceCloudEvent, rrCallback, timeout);
        try {
            HttpUtils.post(this.httpClient, null, target, requestParam, adapter);
        }
        catch (IOException e) {
            throw new EventMeshException(String.format("Request message error, target:%s", target), (Throwable)e);
        }
    }

    private void validateCloudEvent(CloudEvent cloudEvent) {
        Preconditions.checkNotNull((Object)cloudEvent, (Object)"CloudEvent cannot be null");
    }

    private RequestParam buildCommonPostParam(CloudEvent cloudEvent) {
        byte[] bodyByte = EventFormatProvider.getInstance().resolveFormat(cloudEvent.getDataContentType()).serialize(cloudEvent);
        String content = new String(bodyByte, StandardCharsets.UTF_8);
        RequestParam requestParam = new RequestParam(HttpMethod.POST);
        requestParam.addHeader("env", this.eventMeshHttpClientConfig.getEnv()).addHeader("idc", this.eventMeshHttpClientConfig.getIdc()).addHeader("ip", this.eventMeshHttpClientConfig.getIp()).addHeader("pid", this.eventMeshHttpClientConfig.getPid()).addHeader("sys", this.eventMeshHttpClientConfig.getSys()).addHeader("username", this.eventMeshHttpClientConfig.getUserName()).addHeader("passwd", this.eventMeshHttpClientConfig.getPassword()).addHeader("language", "JAVA").addHeader("protocoltype", PROTOCOL_TYPE).addHeader("protocoldesc", PROTOCOL_DESC).addHeader("protocolversion", cloudEvent.getSpecVersion().toString()).addBody("producergroup", this.eventMeshHttpClientConfig.getProducerGroup()).addBody("content", content);
        return requestParam;
    }

    private CloudEvent enhanceCloudEvent(CloudEvent cloudEvent) {
        return CloudEventBuilder.from((CloudEvent)cloudEvent).withExtension("env", this.eventMeshHttpClientConfig.getEnv()).withExtension("idc", this.eventMeshHttpClientConfig.getIdc()).withExtension("ip", this.eventMeshHttpClientConfig.getIp()).withExtension("pid", this.eventMeshHttpClientConfig.getPid()).withExtension("sys", this.eventMeshHttpClientConfig.getSys()).withExtension("language", "JAVA").withExtension("protocoldesc", cloudEvent.getSpecVersion().name()).withExtension("protocolversion", cloudEvent.getSpecVersion().toString()).withExtension("bizseqno", RandomStringUtils.generateNum((int)30)).withExtension("uniqueid", RandomStringUtils.generateNum((int)30)).build();
    }

    private CloudEvent transformMessage(EventMeshRetObj retObj) {
        SendMessageResponseBody.ReplyMessage replyMessage = (SendMessageResponseBody.ReplyMessage)JsonUtils.deserialize((String)retObj.getRetMsg(), SendMessageResponseBody.ReplyMessage.class);
        return null;
    }
}

