/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.common;

import java.util.concurrent.CountDownLatch;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestContext {
    private static Logger logger = LoggerFactory.getLogger(RequestContext.class);
    private Object key;
    private Package request;
    private Package response;
    private CountDownLatch latch;

    public RequestContext(Object key, Package request, CountDownLatch latch) {
        this.key = key;
        this.request = request;
        this.latch = latch;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public Package getRequest() {
        return this.request;
    }

    public void setRequest(Package request) {
        this.request = request;
    }

    public Package getResponse() {
        return this.response;
    }

    public void setResponse(Package response) {
        this.response = response;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    public void finish(Package msg) {
        this.response = msg;
        this.latch.countDown();
    }

    public static RequestContext context(Object key, Package request, CountDownLatch latch) throws Exception {
        RequestContext c = new RequestContext(key, request, latch);
        logger.info("_RequestContext|create|key=" + key);
        return c;
    }

    public static Object key(Package request) {
        return request.getHeader().getSeq();
    }
}

