/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.internal.common;

import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.modules.session.catalina.callback.LocalSessionCacheLoader;
import org.apache.geode.modules.session.catalina.callback.LocalSessionCacheWriter;
import org.apache.geode.modules.session.internal.common.AbstractSessionCache;
import org.apache.geode.modules.session.internal.common.CacheProperty;
import org.apache.geode.modules.util.RegionConfiguration;
import org.apache.geode.modules.util.RegionHelper;
import org.apache.geode.modules.util.TouchPartitionedRegionEntriesFunction;
import org.apache.geode.modules.util.TouchReplicatedRegionEntriesFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerToPeerSessionCache
extends AbstractSessionCache {
    private static final Logger LOG = LoggerFactory.getLogger((String)PeerToPeerSessionCache.class.getName());
    private Cache cache;
    private static final String DEFAULT_REGION_ATTRIBUTES_ID = RegionShortcut.REPLICATE.toString();
    private static final Boolean DEFAULT_ENABLE_LOCAL_CACHE = false;

    public PeerToPeerSessionCache(Cache cache, Map<CacheProperty, Object> properties) {
        this.cache = cache;
        this.properties.put(CacheProperty.REGION_ATTRIBUTES_ID, DEFAULT_REGION_ATTRIBUTES_ID);
        this.properties.put(CacheProperty.ENABLE_LOCAL_CACHE, DEFAULT_ENABLE_LOCAL_CACHE);
        this.properties.putAll(properties);
    }

    @Override
    public void initialize() {
        this.registerFunctions();
        this.createOrRetrieveRegion();
        boolean enableLocalCache = (Boolean)this.properties.get((Object)CacheProperty.ENABLE_LOCAL_CACHE);
        this.operatingRegion = enableLocalCache ? this.createOrRetrieveLocalRegion() : this.sessionRegion;
        this.createStatistics();
    }

    @Override
    public GemFireCache getCache() {
        return this.cache;
    }

    @Override
    public boolean isClientServer() {
        return false;
    }

    private void registerFunctions() {
        if (!FunctionService.isRegistered((String)"touch-partitioned-region-entries")) {
            FunctionService.registerFunction((Function)new TouchPartitionedRegionEntriesFunction());
        }
        if (!FunctionService.isRegistered((String)"touch-replicated-region-entries")) {
            FunctionService.registerFunction((Function)new TouchReplicatedRegionEntriesFunction());
        }
    }

    private void createOrRetrieveRegion() {
        RegionConfiguration configuration = this.createRegionConfiguration();
        Region region = this.cache.getRegion((String)this.properties.get((Object)CacheProperty.REGION_NAME));
        if (region == null) {
            region = RegionHelper.createRegion((Cache)this.cache, (RegionConfiguration)configuration);
            LOG.info("Created new session region: {}", (Object)region);
        } else {
            LOG.info("Retrieved existing session region: {}", (Object)region);
            RegionHelper.validateRegion((Cache)this.cache, (RegionConfiguration)configuration, (Region)region);
        }
        this.sessionRegion = region;
    }

    private Region<String, HttpSession> createOrRetrieveLocalRegion() {
        String frontingRegionName = this.sessionRegion.getName() + "_local";
        Region frontingRegion = this.cache.getRegion(frontingRegionName);
        if (frontingRegion == null) {
            RegionFactory factory = this.cache.createRegionFactory(RegionShortcut.LOCAL_HEAP_LRU);
            factory.setCacheLoader((CacheLoader)new LocalSessionCacheLoader(this.sessionRegion));
            factory.setCacheWriter((CacheWriter)new LocalSessionCacheWriter(this.sessionRegion));
            frontingRegion = factory.create(frontingRegionName);
            LOG.info("Created new local session region: {}", (Object)frontingRegion);
        } else {
            LOG.info("Retrieved existing local session region: {}", (Object)frontingRegion);
        }
        return frontingRegion;
    }
}

