/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.internal.filter;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.apache.geode.modules.session.internal.filter.GemfireHttpSession;
import org.apache.geode.modules.session.internal.filter.SessionManager;
import org.apache.geode.modules.session.internal.filter.attributes.AbstractSessionAttributes;

public class DummySessionManager
implements SessionManager {
    private final Map<String, HttpSession> sessions = new HashMap<String, HttpSession>();

    @Override
    public void start(Object config, ClassLoader loader) {
    }

    @Override
    public void stop() {
    }

    @Override
    public HttpSession getSession(String id) {
        return this.sessions.get(id);
    }

    @Override
    public HttpSession wrapSession(HttpSession nativeSession) {
        String id = this.generateId();
        Attributes attributes = new Attributes();
        GemfireHttpSession session = new GemfireHttpSession(id, nativeSession);
        session.setManager(this);
        session.setAttributes(attributes);
        this.sessions.put(id, session);
        return session;
    }

    @Override
    public HttpSession getWrappingSession(String nativeId) {
        return this.sessions.get(nativeId);
    }

    @Override
    public void putSession(HttpSession session) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void destroySession(String id) {
        this.sessions.remove(id);
    }

    @Override
    public String destroyNativeSession(String id) {
        return null;
    }

    @Override
    public String getSessionCookieName() {
        return "JSESSIONID";
    }

    @Override
    public String getJvmId() {
        return "jvm-id";
    }

    private String generateId() {
        return UUID.randomUUID().toString().toUpperCase() + "-GF";
    }

    private class Attributes
    extends AbstractSessionAttributes {
        private Attributes() {
        }

        @Override
        public Object putAttribute(String attr, Object value) {
            return this.attributes.put(attr, value);
        }

        @Override
        public Object removeAttribute(String attr) {
            return this.attributes.remove(attr);
        }
    }
}

