/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.internal.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.Delta;
import org.apache.geode.Instantiator;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.modules.session.internal.filter.GemfireSessionManager;
import org.apache.geode.modules.session.internal.filter.SessionManager;
import org.apache.geode.modules.session.internal.filter.attributes.AbstractSessionAttributes;
import org.apache.geode.modules.session.internal.filter.attributes.SessionAttributes;
import org.apache.geode.modules.util.ClassLoaderObjectInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GemfireHttpSession
implements HttpSession,
DataSerializable,
Delta {
    private static final transient Logger LOG = LoggerFactory.getLogger((String)GemfireHttpSession.class.getName());
    private static final long serialVersionUID = 238915238964017823L;
    private String id;
    private SessionAttributes attributes;
    private transient SessionManager manager;
    private HttpSession nativeSession = null;
    private boolean isValid = true;
    private boolean isNew = true;
    private boolean isDirty = false;
    private AtomicBoolean serialized = new AtomicBoolean(false);

    private GemfireHttpSession() {
    }

    public GemfireHttpSession(String id, HttpSession nativeSession) {
        this();
        this.id = id;
        this.nativeSession = nativeSession;
        if (nativeSession != null) {
            this.attributes.setMaxInactiveInterval(nativeSession.getMaxInactiveInterval());
        }
    }

    public Object getAttribute(String name) {
        if (!this.isValid) {
            throw new IllegalStateException("Session is already invalidated");
        }
        Object obj = this.attributes.getAttribute(name);
        if (obj != null) {
            Object tmpObj = null;
            ClassLoader loader = ((GemfireSessionManager)this.manager).getReferenceClassLoader();
            if (obj.getClass().getClassLoader() != loader) {
                LOG.debug("Attribute '{}' needs to be reconstructed with a new classloader", (Object)name);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(obj);
                    oos.close();
                    ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()), loader);
                    tmpObj = ois.readObject();
                }
                catch (IOException e) {
                    LOG.error("Exception while recreating attribute '" + name + "'", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    LOG.error("Exception while recreating attribute '" + name + "'", (Throwable)e);
                }
                if (tmpObj != null) {
                    this.setAttribute(name, tmpObj);
                    obj = tmpObj;
                }
            }
        }
        return obj;
    }

    public Enumeration getAttributeNames() {
        if (!this.isValid) {
            throw new IllegalStateException("Session is already invalidated");
        }
        return Collections.enumeration(this.attributes.getAttributeNames());
    }

    public long getCreationTime() {
        if (this.nativeSession != null) {
            return this.nativeSession.getCreationTime();
        }
        return 0L;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        if (!this.isValid) {
            throw new IllegalStateException("Session is already invalidated");
        }
        return this.attributes.getLastAccessedTime();
    }

    public ServletContext getServletContext() {
        if (this.nativeSession != null) {
            return this.nativeSession.getServletContext();
        }
        return null;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        return this.attributes.getAttributeNames().toArray(new String[0]);
    }

    public void invalidate() {
        this.nativeSession.invalidate();
        this.manager.destroySession(this.id);
        this.isValid = false;
    }

    public boolean isNew() {
        if (!this.isValid) {
            throw new IllegalStateException("Session is already invalidated");
        }
        return this.isNew;
    }

    public void setIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    public void setMaxInactiveInterval(int interval) {
        if (this.nativeSession != null) {
            this.nativeSession.setMaxInactiveInterval(interval);
        }
        this.attributes.setMaxInactiveInterval(interval);
        this.isDirty = true;
    }

    public int getMaxInactiveInterval() {
        if (this.nativeSession != null) {
            return this.nativeSession.getMaxInactiveInterval();
        }
        return this.attributes.getMaxIntactiveInterval();
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        LOG.debug("Session {} removing attribute {}", (Object)this.getId(), (Object)name);
        this.nativeSession.removeAttribute(name);
        this.attributes.removeAttribute(name);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session {} setting attribute {} = '{}'", new Object[]{this.id, name, value});
        }
        this.isDirty = true;
        this.nativeSession.setAttribute(name, value);
        if (value == null) {
            this.removeAttribute(name);
        } else {
            this.attributes.putAttribute(name, value);
        }
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.id, (DataOutput)out);
        DataSerializer.writeObject((Object)this.attributes, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.id = DataSerializer.readString((DataInput)in);
        this.attributes = (SessionAttributes)DataSerializer.readObject((DataInput)in);
        if (this.getNativeSession() != null) {
            for (String s : this.attributes.getAttributeNames()) {
                this.getNativeSession().setAttribute(s, this.attributes.getAttribute(s));
            }
        }
        this.serialized.set(true);
        this.attributes.setSession(this);
    }

    public boolean hasDelta() {
        return this.isDirty;
    }

    public void toDelta(DataOutput out) throws IOException {
        if (this.attributes instanceof Delta) {
            ((Delta)this.attributes).toDelta(out);
        } else {
            this.toData(out);
        }
    }

    public void fromDelta(DataInput in) throws IOException, InvalidDeltaException {
        if (this.attributes instanceof Delta) {
            ((Delta)this.attributes).fromDelta(in);
        } else {
            try {
                this.fromData(in);
            }
            catch (ClassNotFoundException cex) {
                throw new IOException("Unable to forward fromDelta() call to fromData()", cex);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[id=").append(this.id).append(", isNew=").append(this.isNew).append(", isValid=").append(this.isValid).append(", hasDelta=").append(this.hasDelta()).append(", lastAccessedTime=").append(this.attributes.getLastAccessedTime()).append(", jvmOwnerId=").append(this.attributes.getJvmOwnerId());
        builder.append("]");
        return builder.toString();
    }

    public void putInRegion() {
        this.manager.putSession(this);
        this.isDirty = false;
    }

    public boolean isValid() {
        long now;
        if (!this.isValid) {
            return false;
        }
        return this.getMaxInactiveInterval() < 0 || (now = System.currentTimeMillis()) - this.attributes.getLastAccessedTime() < (long)(this.getMaxInactiveInterval() * 1000);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setManager(SessionManager manager) {
        this.manager = manager;
    }

    public HttpSession getNativeSession() {
        return this.nativeSession;
    }

    public void setNativeSession(HttpSession session) {
        this.nativeSession = session;
    }

    public void failoverSession(HttpSession session) {
        LOG.debug("Failing over session {} to {}", (Object)this.getId(), (Object)session.getId());
        this.setNativeSession(session);
        for (String name : this.attributes.getAttributeNames()) {
            LOG.debug("Copying '{}' => {}", (Object)name, this.attributes.getAttribute(name));
            session.setAttribute(name, this.attributes.getAttribute(name));
        }
        session.setMaxInactiveInterval(this.attributes.getMaxIntactiveInterval());
        this.manager.putSession(this);
    }

    public void updateAccessTime() {
        this.attributes.setLastAccessedTime(System.currentTimeMillis());
    }

    public void setAttributes(AbstractSessionAttributes attributes) {
        this.attributes = attributes;
    }

    public boolean justSerialized() {
        return this.serialized.getAndSet(false);
    }

    public void commit() {
        this.attributes.setJvmOwnerId(this.manager.getJvmId());
        this.attributes.flush();
    }

    public String getJvmOwnerId() {
        if (this.attributes != null) {
            return this.attributes.getJvmOwnerId();
        }
        return null;
    }

    static {
        Instantiator.register((Instantiator)new Instantiator(GemfireHttpSession.class, 27315){

            public DataSerializable newInstance() {
                return new GemfireHttpSession();
            }
        });
    }
}

