/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.modules.session.internal.filter.attributes;

import org.apache.geode.DataSerializable;
import org.apache.geode.Instantiator;
import org.apache.geode.modules.session.internal.filter.attributes.AbstractDeltaSessionAttributes;
import org.apache.geode.modules.session.internal.filter.attributes.DeltaEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaQueuedSessionAttributes
extends AbstractDeltaSessionAttributes {
    private static final Logger LOG = LoggerFactory.getLogger((String)DeltaQueuedSessionAttributes.class.getName());
    private Trigger trigger = Trigger.SET;

    public void setReplicationTrigger(String trigger) {
        this.trigger = Trigger.valueOf(trigger.toUpperCase());
    }

    @Override
    public Object getAttribute(String attr) {
        if (this.trigger == Trigger.SET_AND_GET) {
            this.deltas.put(attr, new DeltaEvent(this.session, attr));
        }
        return super.getAttribute(attr);
    }

    @Override
    public Object putAttribute(String attr, Object value) {
        Object obj = this.attributes.put(attr, value);
        this.deltas.put(attr, new DeltaEvent(true, attr, value));
        return obj;
    }

    @Override
    public Object removeAttribute(String attr) {
        Object obj = this.attributes.remove(attr);
        this.deltas.put(attr, new DeltaEvent(false, attr, null));
        return obj;
    }

    static {
        Instantiator.register((Instantiator)new Instantiator(DeltaQueuedSessionAttributes.class, 3479){

            public DataSerializable newInstance() {
                return new DeltaQueuedSessionAttributes();
            }
        });
    }

    private static enum Trigger {
        SET,
        SET_AND_GET;

    }
}

