/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.geode.tools.pulse.internal.controllers.PulseController;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PulseAppListener
implements ServletContextListener {
    private static final Logger logger = LogManager.getLogger();
    private final ResourceBundle resourceBundle = Repository.get().getResourceBundle();
    private Properties pulseProperties;
    private Properties pulseSecurityProperties;

    public void contextDestroyed(ServletContextEvent event) {
        Repository.get().removeAllClusters();
        logger.info("{}{}", (Object)this.resourceBundle.getString("LOG_MSG_CONTEXT_DESTROYED"), (Object)event.getServletContext().getContextPath());
    }

    public void contextInitialized(ServletContextEvent event) {
        logger.info(this.resourceBundle.getString("LOG_MSG_CONTEXT_INITIALIZED"));
        this.pulseProperties = this.loadProperties("pulse.properties");
        this.loadPulseVersionDetails();
        this.pulseSecurityProperties = this.loadProperties("pulsesecurity.properties");
        Repository repository = Repository.get();
        logger.info(this.resourceBundle.getString("LOG_MSG_CHECK_APP_RUNNING_MODE"));
        boolean sysIsEmbedded = Boolean.getBoolean("pulse.embedded");
        if (sysIsEmbedded) {
            logger.info(this.resourceBundle.getString("LOG_MSG_APP_RUNNING_EMBEDDED_MODE"));
            repository.setJmxUseLocator(Boolean.valueOf(false));
            repository.setHost(System.getProperty("pulse.host", "localhost"));
            repository.setPort(System.getProperty("pulse.port", "1099"));
            repository.setUseSSLManager(Boolean.valueOf(System.getProperty("pulse.useSSL.manager")).booleanValue());
            repository.setUseSSLLocator(Boolean.valueOf(System.getProperty("pulse.useSSL.locator")).booleanValue());
        } else {
            logger.info(this.resourceBundle.getString("LOG_MSG_APP_RUNNING_NONEMBEDDED_MODE"));
            repository.setJmxUseLocator(Boolean.valueOf(this.pulseProperties.getProperty("pulse.useLocator")));
            repository.setHost(this.pulseProperties.getProperty("pulse.host", "localhost"));
            repository.setPort(this.pulseProperties.getProperty("pulse.port", "1099"));
            repository.setUseSSLManager(Boolean.valueOf(this.pulseProperties.getProperty("pulse.useSSL.manager", "false")).booleanValue());
            repository.setUseSSLLocator(Boolean.valueOf(this.pulseProperties.getProperty("pulse.useSSL.locator", "false")).booleanValue());
            if (!this.pulseSecurityProperties.isEmpty()) {
                Set<Map.Entry<Object, Object>> entrySet = this.pulseSecurityProperties.entrySet();
                for (Map.Entry<Object, Object> entry : entrySet) {
                    String key = (String)entry.getKey();
                    if (!key.startsWith("javax.net.ssl.")) continue;
                    String val = (String)entry.getValue();
                    System.setProperty(key, val);
                }
            }
        }
    }

    private void loadPulseVersionDetails() {
        Properties properties = this.loadProperties("GemFireVersion.properties");
        PulseController.pulseVersion.setPulseVersion(properties.getProperty("Product-Version", ""));
        PulseController.pulseVersion.setPulseBuildId(properties.getProperty("Build-Id", ""));
        PulseController.pulseVersion.setPulseBuildDate(properties.getProperty("Build-Date", ""));
        PulseController.pulseVersion.setPulseSourceDate(properties.getProperty("Source-Date", ""));
        PulseController.pulseVersion.setPulseSourceRevision(properties.getProperty("Source-Revision", ""));
        PulseController.pulseVersion.setPulseSourceRepository(properties.getProperty("Source-Repository", ""));
        logger.info(PulseController.pulseVersion.getPulseVersionLogMessage());
    }

    private Properties loadProperties(String propertyFile) {
        Properties properties = new Properties();
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertyFile);){
            logger.info(propertyFile + " " + this.resourceBundle.getString("LOG_MSG_FILE_FOUND"));
            properties.load(stream);
        }
        catch (IOException e) {
            logger.error(this.resourceBundle.getString("LOG_MSG_EXCEPTION_LOADING_PROPERTIES_FILE"), (Throwable)e);
        }
        return properties;
    }
}

