/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.security;

import java.util.ArrayList;
import java.util.Collection;
import javax.management.remote.JMXConnector;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.security.GemFireAuthentication;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class GemFireAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LogManager.getLogger();

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        GemFireAuthentication gemAuth;
        if (authentication instanceof GemFireAuthentication && (gemAuth = (GemFireAuthentication)authentication).isAuthenticated()) {
            return gemAuth;
        }
        String name = authentication.getName();
        String password = authentication.getCredentials().toString();
        logger.debug("Connecting to GemFire with user=" + name);
        JMXConnector jmxc = Repository.get().getCluster(name, password).getJMXConnector();
        if (jmxc == null) {
            throw new BadCredentialsException("Error connecting to GemFire JMX Server");
        }
        ArrayList list = GemFireAuthentication.populateAuthorities((JMXConnector)jmxc);
        GemFireAuthentication auth = new GemFireAuthentication(authentication.getPrincipal(), authentication.getCredentials(), (Collection)list, jmxc);
        logger.debug("For user " + name + " authList=" + list);
        return auth;
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}

