/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;

public class LogoutHandler
extends SimpleUrlLogoutSuccessHandler
implements LogoutSuccessHandler {
    private static final Logger logger = LogManager.getLogger();

    public LogoutHandler(String defaultTargetURL) {
        this.setDefaultTargetUrl(defaultTargetURL);
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        if (authentication != null) {
            Repository.get().logoutUser(authentication.getName());
            logger.info("#LogoutHandler: GemFireAuthentication JMX Connection Closed.");
        }
        super.onLogoutSuccess(request, response, authentication);
    }
}

