/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.DecimalFormat;
import javax.servlet.http.HttpServletRequest;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="ClusterDetails")
@Scope(value="singleton")
public class ClusterDetailsService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();

    public ObjectNode execute(HttpServletRequest request) throws Exception {
        String userName = request.getUserPrincipal().getName();
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        Cluster.Alert[] alertsList = cluster.getAlertsList();
        int severeAlertCount = 0;
        int errorAlertCount = 0;
        int warningAlertCount = 0;
        int infoAlertCount = 0;
        for (Cluster.Alert alertObj : alertsList) {
            if (alertObj.getSeverity() == 0) {
                ++severeAlertCount;
                continue;
            }
            if (alertObj.getSeverity() == 1) {
                ++errorAlertCount;
                continue;
            }
            if (alertObj.getSeverity() == 2) {
                ++warningAlertCount;
                continue;
            }
            ++infoAlertCount;
        }
        responseJSON.put("clusterName", cluster.getServerName());
        responseJSON.put("severeAlertCount", severeAlertCount);
        responseJSON.put("errorAlertCount", errorAlertCount);
        responseJSON.put("warningAlertCount", warningAlertCount);
        responseJSON.put("infoAlertCount", infoAlertCount);
        responseJSON.put("totalMembers", cluster.getMemberCount());
        responseJSON.put("servers", cluster.getServerCount());
        responseJSON.put("clients", cluster.getClientConnectionCount());
        responseJSON.put("locators", cluster.getLocatorCount());
        responseJSON.put("totalRegions", cluster.getTotalRegionCount());
        Long heapSize = cluster.getTotalHeapSize();
        DecimalFormat df2 = new DecimalFormat("###.##");
        Double heapS = heapSize.doubleValue() / 1024.0;
        responseJSON.put("totalHeap", Double.valueOf(df2.format(heapS)));
        responseJSON.put("functions", cluster.getRunningFunctionCount());
        responseJSON.put("uniqueCQs", cluster.getRegisteredCQCount());
        responseJSON.put("subscriptions", cluster.getSubscriptionCount());
        responseJSON.put("txnCommitted", cluster.getTxnCommittedCount());
        responseJSON.put("txnRollback", cluster.getTxnRollbackCount());
        responseJSON.put("userName", userName);
        return responseJSON;
    }
}

