/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.apache.geode.tools.pulse.internal.util.TimeUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="ClusterMembers")
@Scope(value="singleton")
public class ClusterMemberService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();
    private final String HEAP_USAGE = "heapUsage";

    public ObjectNode execute(HttpServletRequest request) throws Exception {
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        Cluster.Member[] clusterMembersList = cluster.getMembers();
        ArrayNode memberListJson = this.mapper.createArrayNode();
        for (Cluster.Member clusterMember : clusterMembersList) {
            ObjectNode memberJSON = this.mapper.createObjectNode();
            memberJSON.put("gemfireVersion", clusterMember.getGemfireVersion());
            memberJSON.put("memberId", clusterMember.getId());
            memberJSON.put("name", clusterMember.getName());
            memberJSON.put("host", clusterMember.getHost());
            ArrayList<String> serverGroups = clusterMember.getServerGroups();
            if (serverGroups.size() == 0) {
                serverGroups = new ArrayList<String>();
                serverGroups.add("Default");
            }
            memberJSON.put("serverGroups", this.mapper.valueToTree(serverGroups));
            ArrayList<String> redundancyZones = clusterMember.getRedundancyZones();
            if (redundancyZones.size() == 0) {
                redundancyZones = new ArrayList<String>();
                redundancyZones.add("Default");
            }
            memberJSON.put("redundancyZones", this.mapper.valueToTree(redundancyZones));
            long usedHeapSize = cluster.getUsedHeapSize();
            long currentHeap = clusterMember.getCurrentHeapSize();
            if (usedHeapSize > 0L) {
                double heapUsage = (double)currentHeap / (double)usedHeapSize * 100.0;
                this.getClass();
                memberJSON.put("heapUsage", this.truncate(heapUsage, 2));
            } else {
                this.getClass();
                memberJSON.put("heapUsage", 0);
            }
            double currentCPUUsage = clusterMember.getCpuUsage();
            double loadAvg = clusterMember.getLoadAverage();
            memberJSON.put("cpuUsage", this.truncate(currentCPUUsage, 2));
            memberJSON.put("currentHeapUsage", clusterMember.getCurrentHeapSize());
            memberJSON.put("isManager", clusterMember.isManager());
            memberJSON.put("uptime", TimeUtils.convertTimeSecondsToHMS((long)clusterMember.getUptime()));
            memberJSON.put("loadAvg", this.truncate(loadAvg, 2));
            memberJSON.put("sockets", clusterMember.getTotalFileDescriptorOpen());
            memberJSON.put("threads", clusterMember.getNumThreads());
            memberJSON.put("clients", clusterMember.getMemberClientsHMap().size());
            memberJSON.put("queues", clusterMember.getQueueBacklog());
            memberListJson.add((JsonNode)memberJSON);
        }
        responseJSON.put("members", (JsonNode)memberListJson);
        return responseJSON;
    }

    private double truncate(double value, int places) {
        return new BigDecimal(value).setScale(places, RoundingMode.HALF_UP).doubleValue();
    }
}

