/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="ClusterMembersRGraph")
@Scope(value="singleton")
public class ClusterMembersRGraphService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();
    private final String CLUSTER = "clustor";
    private final String MEMBER_COUNT = "memberCount";
    private final String ID = "id";
    private final String NAME = "name";
    private final String DATA = "data";
    private final String MEMORY_USAGE = "memoryUsage";
    private final String CPU_USAGE = "cpuUsage";
    private final String REGIONS = "regions";
    private final String HOST = "host";
    private final String PORT = "port";
    private final String CLIENTS = "clients";
    private final String GC_PAUSES = "gcPauses";
    private final String GATEWAY_SENDER = "gatewaySender";
    private final String GATEWAY_RECEIVER = "gatewayReceiver";
    private final String LOAD_AVG = "loadAvg";
    private final String SOCKETS = "sockets";
    private final String THREADS = "threads";
    private final String NUM_THREADS = "numThreads";
    private final String MEMBER_NODE_TYPE_NORMAL = "Normal";
    private final String MEMBER_NODE_TYPE_WARNING = "Warning";
    private final String MEMBER_NODE_TYPE_ERROR = "Error";
    private final String MEMBER_NODE_TYPE_SEVERE = "Severe";
    private final String CHILDREN = "children";
    private List<String> severeAlertList;
    private List<String> errorAlertsList;
    private List<String> warningAlertsList;

    public ObjectNode execute(HttpServletRequest request) throws Exception {
        Repository repository = Repository.get();
        Cluster cluster = repository.getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        this.getClass();
        responseJSON.put("clustor", (JsonNode)this.getPhysicalServerJson(cluster, repository.getHost(), repository.getPort()));
        this.getClass();
        responseJSON.put("memberCount", cluster.getMemberCount());
        return responseJSON;
    }

    private ObjectNode getPhysicalServerJson(Cluster cluster, String host, String port) {
        Map physicalToMember = cluster.getPhysicalToMember();
        ObjectNode clusterTopologyJSON = this.mapper.createObjectNode();
        this.getClass();
        clusterTopologyJSON.put("id", cluster.getClusterId());
        this.getClass();
        clusterTopologyJSON.put("name", cluster.getClusterId());
        ObjectNode data1 = this.mapper.createObjectNode();
        this.getClass();
        clusterTopologyJSON.put("data", (JsonNode)data1);
        ArrayNode childHostArray = this.mapper.createArrayNode();
        DecimalFormat df2 = new DecimalFormat("###.##");
        this.updateAlertLists(cluster);
        for (Map.Entry physicalToMem : physicalToMember.entrySet()) {
            String hostNodeType;
            String hostStatus;
            String hostName = (String)physicalToMem.getKey();
            double hostCpuUsage = 0.0;
            long hostMemoryUsage = 0L;
            double hostLoadAvg = 0.0;
            int hostNumThreads = 0;
            long hostSockets = 0L;
            boolean hostSevere = false;
            boolean hostError = false;
            boolean hostWarning = false;
            ObjectNode childHostObject = this.mapper.createObjectNode();
            this.getClass();
            childHostObject.put("id", hostName);
            this.getClass();
            childHostObject.put("name", hostName);
            ArrayNode membersArray = this.mapper.createArrayNode();
            List memberList = (List)physicalToMem.getValue();
            for (Cluster.Member member : memberList) {
                ObjectNode memberJSONObj = this.mapper.createObjectNode();
                this.getClass();
                memberJSONObj.put("id", member.getId());
                this.getClass();
                memberJSONObj.put("name", member.getName());
                ObjectNode memberData = this.mapper.createObjectNode();
                memberData.put("gemfireVersion", member.getGemfireVersion());
                Long currentHeap = member.getCurrentHeapSize();
                Long usedHeapSize = cluster.getUsedHeapSize();
                if (usedHeapSize > 0L) {
                    double heapUsage = currentHeap.doubleValue() / usedHeapSize.doubleValue() * 100.0;
                    this.getClass();
                    memberData.put("memoryUsage", Double.valueOf(df2.format(heapUsage)));
                } else {
                    this.getClass();
                    memberData.put("memoryUsage", 0);
                }
                double currentCPUUsage = member.getCpuUsage();
                this.getClass();
                memberData.put("cpuUsage", Double.valueOf(df2.format(currentCPUUsage)));
                this.getClass();
                memberData.put("regions", member.getMemberRegions().size());
                this.getClass();
                memberData.put("host", member.getHost());
                if (member.getMemberPort() == null || member.getMemberPort().equals("")) {
                    this.getClass();
                    memberData.put("port", "-");
                } else {
                    this.getClass();
                    memberData.put("port", member.getMemberPort());
                }
                this.getClass();
                memberData.put("clients", member.getMemberClientsHMap().size());
                this.getClass();
                memberData.put("gcPauses", member.getGarbageCollectionCount());
                this.getClass();
                memberData.put("numThreads", member.getNumThreads());
                hostCpuUsage = member.getHostCpuUsage();
                hostMemoryUsage += member.getCurrentHeapSize();
                hostLoadAvg = member.getLoadAverage();
                hostNumThreads = member.getNumThreads();
                hostSockets = member.getTotalFileDescriptorOpen();
                String memberNodeType = "";
                if (this.severeAlertList.contains(member.getName())) {
                    this.getClass();
                    memberNodeType = this.getMemberNodeType(member, "Severe");
                    if (!hostSevere) {
                        hostSevere = true;
                    }
                } else if (this.errorAlertsList.contains(member.getName())) {
                    this.getClass();
                    memberNodeType = this.getMemberNodeType(member, "Error");
                    if (!hostError) {
                        hostError = true;
                    }
                } else if (this.warningAlertsList.contains(member.getName())) {
                    this.getClass();
                    memberNodeType = this.getMemberNodeType(member, "Warning");
                    if (!hostWarning) {
                        hostWarning = true;
                    }
                } else {
                    this.getClass();
                    memberNodeType = this.getMemberNodeType(member, "Normal");
                }
                memberData.put("nodeType", memberNodeType);
                memberData.put("$type", memberNodeType);
                this.getClass();
                memberData.put("gatewaySender", member.getGatewaySenderList().size());
                if (member.getGatewayReceiver() != null) {
                    this.getClass();
                    memberData.put("gatewayReceiver", 1);
                } else {
                    this.getClass();
                    memberData.put("gatewayReceiver", 0);
                }
                this.getClass();
                memberJSONObj.put("data", (JsonNode)memberData);
                this.getClass();
                memberJSONObj.put("children", (JsonNode)this.mapper.createArrayNode());
                membersArray.add((JsonNode)memberJSONObj);
            }
            ObjectNode data = this.mapper.createObjectNode();
            this.getClass();
            data.put("loadAvg", Double.valueOf(df2.format(hostLoadAvg)));
            this.getClass();
            data.put("sockets", hostSockets);
            this.getClass();
            data.put("threads", hostNumThreads);
            this.getClass();
            data.put("cpuUsage", Double.valueOf(df2.format(hostCpuUsage)));
            this.getClass();
            data.put("memoryUsage", hostMemoryUsage);
            if (hostSevere) {
                this.getClass();
                hostStatus = "Severe";
                hostNodeType = "hostSevereNode";
            } else if (hostError) {
                this.getClass();
                hostStatus = "Error";
                hostNodeType = "hostErrorNode";
            } else if (hostWarning) {
                this.getClass();
                hostStatus = "Warning";
                hostNodeType = "hostWarningNode";
            } else {
                this.getClass();
                hostStatus = "Normal";
                hostNodeType = "hostNormalNode";
            }
            data.put("hostStatus", hostStatus);
            data.put("$type", hostNodeType);
            this.getClass();
            childHostObject.put("data", (JsonNode)data);
            this.getClass();
            childHostObject.put("children", (JsonNode)membersArray);
            childHostArray.add((JsonNode)childHostObject);
        }
        this.getClass();
        clusterTopologyJSON.put("children", (JsonNode)childHostArray);
        return clusterTopologyJSON;
    }

    private String getMemberNodeType(Cluster.Member member, String memberState) {
        String memberNodeType = "";
        if (member.isLocator() && member.isServer() && member.isManager()) {
            memberNodeType = "memberLocatorManagerServer" + memberState + "Node";
        } else if (member.isLocator() && member.isServer() && !member.isManager()) {
            memberNodeType = "memberLocatorServer" + memberState + "Node";
        } else if (member.isLocator() && !member.isServer() && member.isManager()) {
            memberNodeType = "memberLocatorManager" + memberState + "Node";
        } else if (member.isLocator() && !member.isServer() && !member.isManager()) {
            memberNodeType = "memberLocator" + memberState + "Node";
        } else if (!member.isLocator() && member.isServer() && member.isManager()) {
            memberNodeType = "memberManagerServer" + memberState + "Node";
        } else if (!member.isLocator() && member.isServer() && !member.isManager()) {
            memberNodeType = "memberServer" + memberState + "Node";
        } else if (!member.isLocator() && !member.isServer() && member.isManager()) {
            memberNodeType = "memberManager" + memberState + "Node";
        } else if (!(member.isLocator() || member.isServer() || member.isManager())) {
            memberNodeType = "member" + memberState + "Node";
        }
        return memberNodeType;
    }

    private void updateAlertLists(Cluster cluster) {
        Cluster.Alert[] alertsList;
        this.severeAlertList = new ArrayList();
        this.errorAlertsList = new ArrayList();
        this.warningAlertsList = new ArrayList();
        for (Cluster.Alert alert : alertsList = cluster.getAlertsList()) {
            if (alert.getSeverity() == 0) {
                if (this.errorAlertsList.contains(alert.getMemberName())) {
                    this.errorAlertsList.remove(alert.getMemberName());
                } else if (this.warningAlertsList.contains(alert.getMemberName())) {
                    this.warningAlertsList.remove(alert.getMemberName());
                }
                if (this.severeAlertList.contains(alert.getMemberName())) continue;
                this.severeAlertList.add(alert.getMemberName());
                continue;
            }
            if (alert.getSeverity() == 1) {
                if (this.severeAlertList.contains(alert.getMemberName())) continue;
                if (this.warningAlertsList.contains(alert.getMemberName())) {
                    this.warningAlertsList.remove(alert.getMemberName());
                }
                if (this.errorAlertsList.contains(alert.getMemberName())) continue;
                this.errorAlertsList.add(alert.getMemberName());
                continue;
            }
            if (alert.getSeverity() != 2 || this.severeAlertList.contains(alert.getMemberName()) || this.errorAlertsList.contains(alert.getMemberName()) || this.warningAlertsList.contains(alert.getMemberName())) continue;
            this.warningAlertsList.add(alert.getMemberName());
        }
    }
}

