/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="ClusterSelectedRegionsMember")
@Scope(value="singleton")
public class ClusterSelectedRegionsMemberService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LogManager.getLogger();
    private static Comparator<Cluster.RegionOnMember> romEntryCountComparator = (m1, m2) -> {
        long m2EntryCount;
        long m1EntryCount = m1.getEntryCount();
        if (m1EntryCount < (m2EntryCount = m2.getEntryCount())) {
            return -1;
        }
        if (m1EntryCount > m2EntryCount) {
            return 1;
        }
        return 0;
    };

    public ObjectNode execute(HttpServletRequest request) throws Exception {
        String userName = request.getUserPrincipal().getName();
        String pulseData = request.getParameter("pulseData");
        JsonNode parameterMap = this.mapper.readTree(pulseData);
        String selectedRegionFullPath = parameterMap.get("ClusterSelectedRegionsMember").get("regionFullPath").textValue();
        logger.trace("ClusterSelectedRegionsMemberService selectedRegionFullPath = {}", (Object)selectedRegionFullPath);
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        responseJSON.put("clusterName", cluster.getServerName());
        responseJSON.put("userName", userName);
        responseJSON.put("selectedRegionsMembers", (JsonNode)this.getSelectedRegionsMembersJson(cluster, selectedRegionFullPath));
        return responseJSON;
    }

    private ObjectNode getSelectedRegionsMembersJson(Cluster cluster, String selectedRegionFullPath) {
        Cluster.Region reg = cluster.getClusterRegion(selectedRegionFullPath);
        if (reg != null) {
            ObjectNode regionMemberJSON = this.mapper.createObjectNode();
            Cluster.RegionOnMember[] regionOnMembers = reg.getRegionOnMembers();
            List<Cluster.RegionOnMember> romList = Arrays.asList(regionOnMembers);
            Collections.sort(romList, romEntryCountComparator);
            for (Cluster.RegionOnMember rom : romList) {
                ObjectNode memberJSON = this.mapper.createObjectNode();
                memberJSON.put("memberName", rom.getMemberName());
                memberJSON.put("regionFullPath", rom.getRegionFullPath());
                memberJSON.put("entryCount", rom.getEntryCount());
                memberJSON.put("entrySize", rom.getEntrySize());
                memberJSON.put("accessor", rom.getLocalMaxMemory() == 0 ? "True" : "False");
                logger.trace("calling getSelectedRegionsMembersJson :: rom.getLocalMaxMemory() = {}", (Object)rom.getLocalMaxMemory());
                memberJSON.put("memoryReadsTrend", this.mapper.valueToTree((Object)rom.getRegionOnMemberStatisticTrend(0)));
                logger.trace("memoryReadsTrend = {}", (Object)rom.getRegionOnMemberStatisticTrend(0).length);
                memberJSON.put("memoryWritesTrend", this.mapper.valueToTree((Object)rom.getRegionOnMemberStatisticTrend(1)));
                logger.trace("memoryWritesTrend = {}", (Object)rom.getRegionOnMemberStatisticTrend(1).length);
                memberJSON.put("diskReadsTrend", this.mapper.valueToTree((Object)rom.getRegionOnMemberStatisticTrend(3)));
                logger.trace("diskReadsTrend = {}", (Object)rom.getRegionOnMemberStatisticTrend(3).length);
                memberJSON.put("diskWritesTrend", this.mapper.valueToTree((Object)rom.getRegionOnMemberStatisticTrend(4)));
                logger.trace("diskWritesTrend = {}", (Object)rom.getRegionOnMemberStatisticTrend(4).length);
                regionMemberJSON.put(rom.getMemberName(), (JsonNode)memberJSON);
            }
            logger.debug("calling getSelectedRegionsMembersJson :: regionJSON = {}", (Object)regionMemberJSON);
            return regionMemberJSON;
        }
        ObjectNode responseJSON = this.mapper.createObjectNode();
        responseJSON.put("errorOnRegion", "Region [" + selectedRegionFullPath + "] is not available");
        return responseJSON;
    }
}

