/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.DecimalFormat;
import javax.servlet.http.HttpServletRequest;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.apache.geode.tools.pulse.internal.util.NameUtil;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="MemberDetails")
@Scope(value="singleton")
public class MemberDetailsService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();

    public ObjectNode execute(HttpServletRequest request) throws Exception {
        String userName = request.getUserPrincipal().getName();
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        JsonNode requestDataJSON = this.mapper.readTree(request.getParameter("pulseData"));
        String memberName = requestDataJSON.get("MemberDetails").get("memberName").textValue();
        DecimalFormat df2 = new DecimalFormat("###.##");
        Cluster.Member clusterMember = cluster.getMember(NameUtil.makeCompliantName((String)memberName));
        if (clusterMember != null) {
            responseJSON.put("memberId", clusterMember.getId());
            responseJSON.put("name", clusterMember.getName());
            responseJSON.put("host", clusterMember.getHost());
            responseJSON.put("clusterId", cluster.getId());
            responseJSON.put("clusterName", cluster.getServerName());
            responseJSON.put("userName", userName);
            double loadAvg = clusterMember.getLoadAverage();
            responseJSON.put("loadAverage", Double.valueOf(df2.format(loadAvg)));
            responseJSON.put("sockets", clusterMember.getTotalFileDescriptorOpen());
            responseJSON.put("threads", clusterMember.getNumThreads());
            responseJSON.put("offHeapFreeSize", clusterMember.getOffHeapFreeSize());
            responseJSON.put("offHeapUsedSize", clusterMember.getOffHeapUsedSize());
            responseJSON.put("regionsCount", clusterMember.getMemberRegionsList().length);
            responseJSON.put("numClients", clusterMember.getMemberClientsHMap().size());
            Long diskUsageVal = clusterMember.getTotalDiskUsage();
            Double diskUsage = diskUsageVal.doubleValue() / 1024.0;
            responseJSON.put("diskStorageUsed", Double.valueOf(df2.format(diskUsage)));
            Cluster.Alert[] alertsList = cluster.getAlertsList();
            String status = "Normal";
            for (Cluster.Alert alert : alertsList) {
                if (!clusterMember.getName().equals(alert.getMemberName())) continue;
                if (alert.getSeverity() == 0) {
                    status = "Severe";
                    break;
                }
                if (alert.getSeverity() == 1) {
                    status = "Error";
                    continue;
                }
                if (alert.getSeverity() != 2) continue;
                status = "Warning";
            }
            responseJSON.put("status", status);
        } else {
            responseJSON.put("errorOnMember", "Member [" + memberName + "] is not available");
        }
        return responseJSON;
    }
}

