/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.tools.pulse.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.servlet.http.HttpServletRequest;
import org.apache.geode.tools.pulse.internal.data.Cluster;
import org.apache.geode.tools.pulse.internal.data.Repository;
import org.apache.geode.tools.pulse.internal.service.PulseService;
import org.apache.geode.tools.pulse.internal.util.NameUtil;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
@Service(value="MemberGCPauses")
@Scope(value="singleton")
public class MemberGCPausesService
implements PulseService {
    private final ObjectMapper mapper = new ObjectMapper();

    public ObjectNode execute(HttpServletRequest request) throws Exception {
        Cluster cluster = Repository.get().getCluster();
        ObjectNode responseJSON = this.mapper.createObjectNode();
        JsonNode requestDataJSON = this.mapper.readTree(request.getParameter("pulseData"));
        String memberName = requestDataJSON.get("MemberGCPauses").get("memberName").textValue();
        Cluster.Member clusterMember = cluster.getMember(NameUtil.makeCompliantName((String)memberName));
        if (clusterMember != null) {
            responseJSON.put("gcPausesTrend", this.mapper.valueToTree((Object)clusterMember.getMemberStatisticTrend(0)));
            responseJSON.put("gcPausesCount", clusterMember.getGarbageCollectionCount());
        }
        return responseJSON;
    }
}

