/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.rest.internal.web.controllers;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.rest.internal.web.controllers.CommonCrudController;
import org.apache.geode.rest.internal.web.controllers.support.JSONTypes;
import org.apache.geode.rest.internal.web.controllers.support.RegionData;
import org.apache.geode.rest.internal.web.controllers.support.RegionEntryData;
import org.apache.geode.rest.internal.web.exception.ResourceNotFoundException;
import org.apache.geode.rest.internal.web.util.ArrayUtils;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="pdxCrudController")
@Api(value="region", description="region CRUD operations", tags={"region"})
@RequestMapping(value={"/v1"})
public class PdxBasedCrudController
extends CommonCrudController {
    private static final Logger logger = LogService.getLogger();
    static final String REST_API_VERSION = "/v1";
    private static final String DEFAULT_GETALL_RESULT_LIMIT = "50";

    protected String getRestApiVersion() {
        return REST_API_VERSION;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{region}"}, consumes={"application/json"}, produces={"application/json"})
    @ApiOperation(value="create entry", notes="Create (put-if-absent) data in region")
    @ApiResponses(value={@ApiResponse(code=201, message="Created."), @ApiResponse(code=400, message="Data specified (JSON doc) in the request body is invalid."), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=404, message="Region does not exist."), @ApiResponse(code=409, message="Key already exist in region."), @ApiResponse(code=500, message="GemFire throws an error or exception.")})
    @PreAuthorize(value="@securityService.authorize('DATA', 'WRITE', #region)")
    public ResponseEntity<?> create(@PathVariable(value="region") String region, @RequestParam(value="key", required=false) String key, @RequestBody String json) {
        key = this.generateKey(key);
        logger.debug("Posting (creating/putIfAbsent) JSON document ({}) to Region ({}) with Key ({})...", (Object)json, (Object)region, (Object)key);
        region = this.decode(region);
        Object existingPdxObj = null;
        JSONTypes jsonType = this.validateJsonAndFindType(json);
        existingPdxObj = JSONTypes.JSON_ARRAY.equals((Object)jsonType) ? this.postValue(region, (Object)key, (Object)this.convertJsonArrayIntoPdxCollection(json)) : this.postValue(region, (Object)key, (Object)this.convert(json));
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(this.toUri(new String[]{region, key}));
        if (existingPdxObj != null) {
            RegionEntryData data = new RegionEntryData(region);
            data.add(existingPdxObj);
            headers.setContentType(MediaType.APPLICATION_JSON);
            return new ResponseEntity((Object)data, (MultiValueMap)headers, HttpStatus.CONFLICT);
        }
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.CREATED);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{region}"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="read all data for region", notes="Read all data for region. Use limit param to get fixed or limited number of entries.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK."), @ApiResponse(code=400, message="Bad request."), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=404, message="Region does not exist."), @ApiResponse(code=500, message="GemFire throws an error or exception.")})
    @PreAuthorize(value="@securityService.authorize('DATA', 'READ', #region)")
    public ResponseEntity<?> read(@PathVariable(value="region") String region, @RequestParam(value="limit", defaultValue="50") String limit) {
        logger.debug("Reading all data in Region ({})...", (Object)region);
        region = this.decode(region);
        Object valueObjs = null;
        RegionData data = new RegionData(region);
        HttpHeaders headers = new HttpHeaders();
        String keyList = null;
        int regionSize = this.getRegion(region).size();
        ArrayList keys = new ArrayList(regionSize);
        ArrayList values = new ArrayList(regionSize);
        for (Map.Entry entry : this.getValues(region, new String[0]).entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            keys.add(entry.getKey());
            values.add(value);
        }
        if ("ALL".equalsIgnoreCase(limit)) {
            data.add(values);
            keyList = StringUtils.collectionToDelimitedString(keys, (String)",");
        } else {
            String errorMessage;
            try {
                int maxLimit = Integer.valueOf(limit);
                if (maxLimit < 0) {
                    errorMessage = String.format("Negative limit param (%1$s) is not valid!", maxLimit);
                    return new ResponseEntity((Object)this.convertErrorAsJson(errorMessage), HttpStatus.BAD_REQUEST);
                }
                int mapSize = keys.size();
                if (maxLimit > mapSize) {
                    maxLimit = mapSize;
                }
                data.add(values.subList(0, maxLimit));
                keyList = StringUtils.collectionToDelimitedString(keys.subList(0, maxLimit), (String)",");
            }
            catch (NumberFormatException e) {
                errorMessage = String.format("limit param (%1$s) is not valid!", limit);
                return new ResponseEntity((Object)this.convertErrorAsJson(errorMessage), HttpStatus.BAD_REQUEST);
            }
        }
        headers.set("Content-Location", this.toUri(new String[]{region, keyList}).toASCIIString());
        return new ResponseEntity((Object)data, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{region}/{keys}"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="read data for specific keys", notes="Read data for specific set of keys in region.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK."), @ApiResponse(code=400, message="Bad Request."), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=404, message="Region does not exist."), @ApiResponse(code=500, message="GemFire throws an error or exception.")})
    @PreAuthorize(value="@securityService.authorize('READ', #region, #keys)")
    public ResponseEntity<?> read(@PathVariable(value="region") String region, @PathVariable(value="keys") String[] keys, @RequestParam(value="ignoreMissingKey", required=false) String ignoreMissingKey) {
        List unknownKeys;
        logger.debug("Reading data for keys ({}) in Region ({})", (Object)ArrayUtils.toString((String[])keys), (Object)region);
        HttpHeaders headers = new HttpHeaders();
        region = this.decode(region);
        if (keys.length == 1) {
            Object value = this.getValue(region, (Object)keys[0]);
            if (value == null) {
                throw new ResourceNotFoundException(String.format("Key (%1$s) does not exist for region (%2$s) in cache!", keys[0], region));
            }
            RegionEntryData data = new RegionEntryData(region);
            headers.set("Content-Location", this.toUri(new String[]{region, keys[0]}).toASCIIString());
            data.add(value);
            return new ResponseEntity((Object)data, (MultiValueMap)headers, HttpStatus.OK);
        }
        if (ignoreMissingKey != null && !ignoreMissingKey.equalsIgnoreCase("true") && !ignoreMissingKey.equalsIgnoreCase("false")) {
            String errorMessage = String.format("ignoreMissingKey param (%1$s) is not valid. valid usage is ignoreMissingKey=true!", ignoreMissingKey);
            return new ResponseEntity((Object)this.convertErrorAsJson(errorMessage), HttpStatus.BAD_REQUEST);
        }
        if (!"true".equalsIgnoreCase(ignoreMissingKey) && (unknownKeys = this.checkForMultipleKeysExist(region, keys)).size() > 0) {
            String unknownKeysAsStr = StringUtils.collectionToDelimitedString((Collection)unknownKeys, (String)",");
            String erroString = String.format("Requested keys (%1$s) not exist in region (%2$s)", StringUtils.collectionToDelimitedString((Collection)unknownKeys, (String)","), region);
            return new ResponseEntity((Object)this.convertErrorAsJson(erroString), (MultiValueMap)headers, HttpStatus.BAD_REQUEST);
        }
        Map valueObjs = this.getValues(region, keys);
        String keyList = StringUtils.collectionToDelimitedString(valueObjs.keySet(), (String)",");
        headers.set("Content-Location", this.toUri(new String[]{region, keyList}).toASCIIString());
        RegionData data = new RegionData(region);
        data.add(valueObjs.values());
        return new ResponseEntity((Object)data, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{region}/{keys}"}, consumes={"application/json"}, produces={"application/json"})
    @ApiOperation(value="update data for key", notes="Update or insert (put) data for key in region.op=REPLACE, update (replace) data with key if and only if the key exists in regionop=CAS update (compare-and-set) value having key with a new value if and only if the \"@old\" value sent matches the current value for the key in region")
    @ApiResponses(value={@ApiResponse(code=200, message="OK."), @ApiResponse(code=400, message="Bad Request."), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=404, message="Region does not exist or if key is not mapped to some value for REPLACE or CAS."), @ApiResponse(code=409, message="For CAS, @old value does not match to the current value in region"), @ApiResponse(code=500, message="GemFire throws an error or exception.")})
    @PreAuthorize(value="@securityService.authorize('WRITE', #region, #keys)")
    public ResponseEntity<?> update(@PathVariable(value="region") String region, @PathVariable(value="keys") String[] keys, @RequestParam(value="op", defaultValue="PUT") String opValue, @RequestBody String json) {
        logger.debug("updating key(s) for region ({}) ", (Object)region);
        region = this.decode(region);
        if (keys.length > 1) {
            return this.updateMultipleKeys(region, keys, json);
        }
        return this.updateSingleKey(region, keys[0], json, opValue);
    }

    @RequestMapping(method={RequestMethod.HEAD}, value={"/{region}"}, produces={"application/json"})
    @ApiOperation(value="Get total number of entries", notes="Get total number of entries into the specified region")
    @ApiResponses(value={@ApiResponse(code=200, message="OK."), @ApiResponse(code=400, message="Bad request."), @ApiResponse(code=401, message="Invalid Username or Password."), @ApiResponse(code=403, message="Insufficient privileges for operation."), @ApiResponse(code=404, message="Region does not exist."), @ApiResponse(code=500, message="GemFire throws an error or exception.")})
    @PreAuthorize(value="@securityService.authorize('DATA', 'READ', #region)")
    public ResponseEntity<?> size(@PathVariable(value="region") String region) {
        logger.debug("Determining the number of entries in Region ({})...", (Object)region);
        region = this.decode(region);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Resource-Count", String.valueOf(this.getRegion(region).size()));
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.OK);
    }
}

