/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.openapi.impl.model.codec;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.stream.Stream;
import javax.enterprise.inject.Vetoed;
import javax.json.bind.adapter.JsonbAdapter;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

@Vetoed
public final class Serializers {
    private Serializers() {
    }

    @Vetoed
    public static class SchemaTypeSerializer
    extends EnumSerializer<Schema.SchemaType>
    implements JsonbAdapter<Schema.SchemaType, String> {
        public SchemaTypeSerializer() {
            super(Schema.SchemaType.class);
        }
    }

    @Vetoed
    public static class InSerializer
    extends EnumSerializer<Parameter.In>
    implements JsonbAdapter<Parameter.In, String> {
        public InSerializer() {
            super(Parameter.In.class);
        }
    }

    @Vetoed
    public static class SecuritySchemeInSerializer
    extends EnumSerializer<SecurityScheme.In>
    implements JsonbAdapter<SecurityScheme.In, String> {
        public SecuritySchemeInSerializer() {
            super(SecurityScheme.In.class);
        }
    }

    @Vetoed
    public static class SecuritySchemeTypeSerializer
    extends EnumSerializer<SecurityScheme.Type>
    implements JsonbAdapter<SecurityScheme.Type, String> {
        public SecuritySchemeTypeSerializer() {
            super(SecurityScheme.Type.class);
        }
    }

    @Vetoed
    public static class ParameterStyleSerializer
    extends EnumSerializer<Parameter.Style>
    implements JsonbAdapter<Parameter.Style, String> {
        public ParameterStyleSerializer() {
            super(Parameter.Style.class);
        }
    }

    @Vetoed
    public static class HeaderStyleSerializer
    extends EnumSerializer<Header.Style>
    implements JsonbAdapter<Header.Style, String> {
        public HeaderStyleSerializer() {
            super(Header.Style.class);
        }
    }

    @Vetoed
    public static class EncodingStyleSerializer
    extends EnumSerializer<Encoding.Style>
    implements JsonbAdapter<Encoding.Style, String> {
        public EncodingStyleSerializer() {
            super(Encoding.Style.class);
        }
    }

    @Vetoed
    private static abstract class EnumSerializer<E extends Enum<E>>
    implements JsonbAdapter<E, String> {
        private final Class<E> type;

        protected EnumSerializer(Class<E> type) {
            this.type = type;
        }

        public String adaptToJson(E obj) {
            return ((Enum)obj).toString();
        }

        public E adaptFromJson(String obj) {
            try {
                return Enum.valueOf(this.type, obj.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException iae) {
                return (E)Stream.of(this.type.getEnumConstants()).filter(it -> it.toString().equals(obj)).findFirst().orElseThrow(() -> iae);
            }
        }
    }

    @Vetoed
    public static class BigDecimalSerializer
    implements JsonbAdapter<BigDecimal, Number> {
        public Number adaptToJson(BigDecimal obj) {
            if (obj.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0) {
                return obj.longValueExact();
            }
            return obj;
        }

        public BigDecimal adaptFromJson(Number obj) {
            return BigDecimal.class.isInstance(obj) ? (BigDecimal)BigDecimal.class.cast(obj) : BigDecimal.valueOf(obj.doubleValue());
        }
    }
}

